<?php


class STATS_BOL_StatisticDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    

    public function getDtoClassName()
    {
        return 'STATS_BOL_Statistic';
    }

    public function getTableName()
    {
        return OW_DB_PREFIX . 'stats';
    }

    public function add($entityType, $count, $date, $type)
    {
        $statistic = new STATS_BOL_Statistic();
        $statistic->entityType = $entityType;
        $statistic->count = $count;
        $statistic->countType = $type;
        $statistic->date = $date;
        
        $this->save($statistic);
    }
    
    public function findByEntity($entity, $count)
    {
        $example = new OW_Example();
        $example->andFieldEqual('entityType', $entity);
        $example->andFieldGreaterThenOrEqual('date', date("Ymd", time() - (60*60*24*$count)));
        $example->setOrder('date');
        
        return $this->findListByExample($example);
    }
    
    public function checkExists($entity, $date)
    {
        $example = new OW_Example();
        $example->andFieldEqual('entityType', $entity);
        $example->andFieldEqual('date', $date);
        $example->setLimitClause(0, 1);
        
        return count($this->findListByExample($example)) == 1;
    }
}