<?php

class STATS_CLASS_BasicWidget extends BASE_CLASS_Widget
{
    public function __construct( $widget, BASE_CLASS_WidgetParameter $paramObj )
    {
        parent::__construct();
        
        $params = $paramObj->customParamList;
        
        $menuType = new STATS_CLASS_Toolbox($widget->key.'_types');
        $menuEntity = new BASE_CMP_SortControl();
        
        $event = new OW_Event('stats.getLanguageStrings', array('key' => $widget->key, 'widget' => $widget));
        OW::getEventManager()->trigger($event);
        $langs = $event->getData();
        
        $template = OW::getPluginManager()->getPlugin('stats')->getCmpViewDir() . 'chart.html';
        $this->setTemplate($template);
        
        $first = array();
        $datas = array();
        $days = array();
        $datasets = array();
        $dao = STATS_BOL_StatisticDao::getInstance();
        
        $countEntity = 0;
        $countType = 0;
        
        foreach($widget->dbTables as $table)
        {
            $counts = array();
            $result = $dao->findByEntity($table->entity, $params['dayCount']);
            
            if($result == null) continue;
            
            foreach($result as $count) $counts[$count->countType][$count->date] = $count->count;
            
            $menuEntity->addItem($countEntity, $langs['entities'][$table->entity]."<span class='hidden'>".$table->entity."</span>", "javascript://", $countEntity == 0);
            $countEntity++;
            
            ksort($counts);
            
            foreach($counts as $countKey => $countData)
            {
                $menuType->addItem($countKey, $langs['types'][$countKey]."<span class='hidden'>".$countKey."</span>", "", $countType == 0);
                $countType++;
                
                if(!isset($first['type'])) $first['type'] = $countKey;
                
                $datas['counts'][$countKey.'_'.$table->entity] = $countData;
                $datas['info'][$countKey.'_'.$table->entity] = array('labels' => '', 'datasets' => array(array('label' => $this->text('widgets_label_entity_'.$table->entity), 'color' => $widget->color,)));
            }
            
            if(!isset($first['entity'])) $first['entity'] = $table->entity;
        }
        
        if(!isset($datas['info']))
        {
            $datas['counts'] = array();
            $datas['info'] = array();
        }
        
        $labels = array();
        for($i=$params['dayCount']; $i>0; $i--)
        {
            $stamp = date("Ymd", time() - ($i * (60*60*24)));
            $labels[] = date("d.m", time() - ($i * (60*60*24)));
            
            foreach($datas['counts'] as &$day)
                if(!isset($day[$stamp])) $day[$stamp] = 0;
        }
        
        
        foreach($datas['counts'] as $key => &$day)
        {
            ksort($day);
            $temp = array();
            foreach($day as $d) $temp[] = (int)$d;
            $datas['info'][$key]['labels'] = $labels;
            $datas['info'][$key]['datasets'][0]['data'] = json_encode($temp);
        }
        
        $renderType = $menuType->renderIt();
        
        $this->assign("showEntities", $countEntity > 1);
        $this->assign("showTypes", $countType > 1);
        $this->assign("showChart", count($datas['info']) > 0);
        $this->assign("type", $widget->name);
        $this->assign("pluginKey", strtoupper($widget->plugin));
        $this->assign("labels", json_encode($labels));
        $this->assign("datas", $datas['info']);
        $this->assign("first", $first);
        $this->addComponent("menuType", $renderType['menu']);
        $this->addComponent("menuEntity", $menuEntity);
        
        OW::getDocument()->addScript( OW::getPluginManager()->getPlugin('stats')->getStaticJsUrl().'charts.js' );
    }

    
    public static function getSettingList()
    {
        $lang = OW::getLanguage();

        $settingList = array();
        $settingList['dayCount'] = array(
            'presentation' => self::PRESENTATION_NUMBER,
            'label' => $lang->text('stats', 'wid_sett_count'),
            'value' => 7
        );

        return $settingList;
    }

    public static function getAccess()
    {
        return self::ACCESS_ALL;
    }
    
    public function text($key)
    {
        return OW::getLanguage()->text('stats', $key);
    }
}