<?php
	
class STATS_CLASS_CountHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
            self::$classInstance = new self();

        return self::$classInstance;
    }
    
    public function getCount( OW_Event $event )
    {
	    $params = $event->getParams();
        $out = array();
        
        $activePlugins = json_decode(OW::getConfig()->getValue('stats', 'activePlugins'));
        if(!in_array($params['key'], $activePlugins)) return;
        
        $supported = STATS_CLASS_WidgetHandler::getInstance()->getWidgets(false, true);
        if(!in_array($params['key'], $supported)) return;
        
        $dateFrom = $params['dateFrom'];
        $dateTo = $params['dateTo'];
        $paramDate = $params['date'];
        
        switch($params['entity'])
        {
            case "forum_post_attachment":
                $result = OW::getDbo()->queryForRow("SELECT COUNT(e.id) as count FROM `".OW_DB_PREFIX."forum_post_attachment` as e, `".OW_DB_PREFIX."forum_post` as p WHERE e.postId = p.id AND $paramDate > $dateFrom AND $paramDate < $dateTo;");
                $out['new'] = $result['count'];
                $result = OW::getDbo()->queryForRow("SELECT COUNT(e.id) as count FROM `".OW_DB_PREFIX."forum_post_attachment` as e, `".OW_DB_PREFIX."forum_post` as p WHERE e.postId = p.id AND $paramDate < $dateTo;");
                $out['sum'] = $result['count'];
                break;
            
            case "friends_friendship":
                $result = OW::getDbo()->queryForRow("SELECT COUNT(id) as count FROM `".OW_DB_PREFIX."friends_friendship` WHERE status = 'active' AND $paramDate > $dateFrom AND $paramDate < $dateTo;");
                $out['new'] = $result['count'];
                $result = OW::getDbo()->queryForRow("SELECT COUNT(id) as count FROM `".OW_DB_PREFIX."friends_friendship` WHERE status = 'active' AND $paramDate < $dateTo;");
                $out['sum'] = $result['count'];
                break;
                
            case "mailbox_attachment":
                $result = OW::getDbo()->queryForRow("SELECT COUNT(a.id) as count FROM `".OW_DB_PREFIX."mailbox_attachment` as a, `".OW_DB_PREFIX."mailbox_message` as m WHERE a.messageId = m.id AND $paramDate > $dateFrom AND $paramDate < $dateTo;");
                $out['new'] = $result['count'];
                $result = OW::getDbo()->queryForRow("SELECT COUNT(a.id) as count FROM `".OW_DB_PREFIX."mailbox_attachment` as a, `".OW_DB_PREFIX."mailbox_message` as m WHERE a.messageId = m.id AND $paramDate < $dateTo;");
                $out['sum'] = $result['count'];
                break;
                    
            case "newsfeed_comment":
            case "blogs_comment":
            case "video_comment":
            case "photo_comment":
                $plugin = $params['database'];
                $result = OW::getDbo()->queryForRow("SELECT COUNT(c.id) as count FROM `".OW_DB_PREFIX."base_comment` as c, `".OW_DB_PREFIX."base_comment_entity` as e WHERE c.commentEntityId = e.id AND e.pluginKey = '".$plugin."' AND c.createStamp > $dateFrom AND c.createStamp < $dateTo;");
                $out['new'] = $result['count'];
                $result = OW::getDbo()->queryForRow("SELECT COUNT(c.id) as count FROM `".OW_DB_PREFIX."base_comment` as c, `".OW_DB_PREFIX."base_comment_entity` as e WHERE c.commentEntityId = e.id AND e.pluginKey = '".$plugin."' AND c.createStamp < $dateTo;");
                $out['sum'] = $result['count'];
                break;
                    
            default:
                $result = OW::getDbo()->queryForRow("SELECT COUNT(id) as count FROM `".OW_DB_PREFIX.$params['entity']."` WHERE $paramDate > $dateFrom AND $paramDate < $dateTo;");
                $out['new'] = $result['count'];
                $result = OW::getDbo()->queryForRow("SELECT COUNT(id) as count FROM `".OW_DB_PREFIX.$params['entity']."` WHERE $paramDate < $dateTo;");
                $out['sum'] = $result['count'];
                break;
        }
        
        $event->setData($out);
    }
    
    public function getInitCount( OW_Event $event )
    {
        $params = $event->getParams();
        $widgets = STATS_CLASS_WidgetHandler::getInstance()->getWidgets(false, true);
        $timeStamp = $params['time'];
        $out = array();
        $activePlugins = json_decode(OW::getConfig()->getValue('stats', 'activePlugins'));
        
        if(!in_array($params['key'], $activePlugins)) return;
        if(!in_array($params['key'], $widgets)) return;
        
        $widget = STATS_CLASS_WidgetHandler::getInstance()->getWidget($params['key']);
        
        foreach($widget->dbTables as $table)
        {
            if(!$table->init) continue;
            
            $results = null;
            $date = isset($table->date) ? $table->date : 'date';
            
            switch($table->entity)
            {
                case "forum_post_attachment":
                    $results = OW::getDbo()->queryForList("SELECT p.createStamp as date FROM `".OW_DB_PREFIX."forum_post_attachment` as e, `".OW_DB_PREFIX."forum_post` as p WHERE e.postId = p.id AND p.createStamp >= $timeStamp");
                    break;
                    
                case "friends_friendship":
                    $results = OW::getDbo()->queryForRow("SELECT timeStamp as date FROM `".OW_DB_PREFIX."friends_friendship` WHERE status = 'active' AND timeStamp >= $timeStamp");
                    break;
                    
                case "mailbox_attachment":
                    $results = OW::getDbo()->queryForRow("SELECT m.timeStamp as date FROM `".OW_DB_PREFIX."mailbox_attachment` as a, `".OW_DB_PREFIX."mailbox_message` as m WHERE a.messageId = m.id AND m.timeStamp >= $timeStamp");
                    break;
                    
                case "newsfeed_comment":
                case "blogs_comment":
                case "video_comment":
                case "photo_comment":
                    $plugin = $table->db;
                    $results = OW::getDbo()->queryForRow("SELECT c.createStamp as date FROM `".OW_DB_PREFIX."base_comment` as c, `".OW_DB_PREFIX."base_comment_entity` as e WHERE c.commentEntityId = e.entityId AND e.pluginKey = '".$plugin."' AND c.createStamp >= $timeStamp");
                    break;
                    
                default:
                    $results = OW::getDbo()->queryForList("SELECT ".$date." as date FROM `".OW_DB_PREFIX.$table->entity."` WHERE $date >= $timeStamp");
            }
            
            if($results == null) continue;
            
            $counts = array();
            $dao = STATS_BOL_StatisticDao::getInstance();
            
            foreach($results as $result)
            {
                $date = date("Ymd", $result['date']);
                if($date == date("Ymd", time())) continue;
                
                if(isset($counts[$date])) $counts[$date] += 1;
                else $counts[$date] = 1;
            }
            
            $out[$table->entity]['counts'] = $counts;
            $out[$table->entity]['type'] = 'new';
        }
        
        $event->setData($out);
    }
}