<?php
/**
 * Copyright (c) 2015, Mike Gerst
 * All rights reserved.
 *
 * ATTENTION: This is licensed under the CC by-nd
 *
 * Full text of this license can be found at http://creativecommons.org/licenses/by-nd/3.0/legalcode
 */
 
class STATS_CLASS_EventHandler
{
    private $countHandler;
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
            self::$classInstance = new self();

        return self::$classInstance;
    }


    public function init()
    {
        $countHandler = STATS_CLASS_CountHandler::getInstance();
        
        $em = OW::getEventManager();

        $em->bind('base.add_main_console_item', array($this, 'addConsoleItem'));
        $em->bind('stats.getCount', array($countHandler, 'getCount'));
        $em->bind('stats.getInitCount', array($countHandler, 'getInitCount'));
        $em->bind(OW_EventManager::ON_BEFORE_PLUGIN_UNINSTALL, array($this, 'pluginUninstall'));
        $em->bind('stats.getJSON', array($this, 'getJSON'));
        $em->bind('stats.getLanguageStrings', array($this, 'getLanguageStrings'));
        $em->bind('admin.add_auth_labels', array($this, 'addAuthLabels'));
        $em->bind("core.plugins_init", array(new STATS_CLASS_Functions(), "init"));
    }

    
    public function addAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $conf = OW::getConfig();

        $event->add(
            array(
                'stats' => array(
                    'label' => $this->text('eh_auth_label'),
                    'actions' => array(
                        'view_dashboard' => $this->text('eh_auth_dash'),
                        'view_charts_widget' => $this->text('eh_auth_chart')
                    )
                )
            )
        );
    }
    
    function getLanguageStrings( OW_Event $event )
    {
        $params = $event->getParams();
        $key = $params['key'];
        
        $widgets = STATS_CLASS_WidgetHandler::getInstance()->getWidgets(false, true);
        if(!in_array($key, $widgets)) return;
        
        $widget = STATS_CLASS_WidgetHandler::getInstance()->getWidget($key);
        $langs = array();
        
        $langs['title'] = $this->text('widgets_'.$key.'_title');
        $langs['description'] = $this->text('widgets_'.$key.'_description');
        
        foreach($widget->dbTables as $table)
        {
            $langs['entities'][$table->entity] = $this->text('widgets_label_entity_'.$table->entity);
        }
        
        $langs['types']['new'] = $this->text('widgets_label_type_new');
        $langs['types']['sum'] = $this->text('widgets_label_type_sum');
        
        $event->setData($langs);
    }
    
    function addConsoleItem( BASE_CLASS_EventCollector $event )
    {
        $user = OW::getUser();
        if($user->isAuthorized('stats', 'view_dashboard') || $user->isAuthorized('stats'))
            $event->add(array('label' => OW::getLanguage()->text('stats', 'console_statistic'), 'url' => OW_Router::getInstance()->urlForRoute('stats.dashboard')));
    }
    
    function pluginUninstall( OW_Event $event )
    {
        $params = $event->getParams();
        $pluginHandler = new STATS_CLASS_PluginHandler();
        $pluginHandler->deactivate($params['pluginKey']);
        OW::getFeedback()->info($this->text('page_admin_deactivate_success', array('key' => $params['pluginKey'])));
    }
    
    function getJSON( OW_Event $event )
    {
        $params = $event->getParams();
        $plugins = STATS_CLASS_WidgetHandler::getInstance()->getWidgets(false, true);
        
        if(!in_array($params['key'], $plugins)) return;
        
        $json = file_get_contents(OW::getPluginManager()->getPlugin('stats')->getStaticDir().'widgets'.DS.$params['key'].'.json');
        
        $event->setData($json);
    }
    
    
    
    function text($key, $params = null)
    {
        return OW::getLanguage()->text('stats', $key, $params);
    }
}