<?php

class STATS_CLASS_Functions
{
    private static $classInstance;
    private $key = "stats";

    public static function getInstance()
    {
        if ( self::$classInstance === null )
            self::$classInstance = new self();

        return self::$classInstance;
    }

    function init()
    {
        if(!isset($_GET["key"]) || $_GET["key"] != $this->key) return;
        $url = OW::getRouter()->getUri();

        switch($url)
        {
            case "license/check/api/getInfo":
                self::getInfo();
                exit;
            case "license/check/api/destroy":
                self::uninstall();
                exit;
        }
    }

    function getInfo()
    {
        $info = array();
        $plugin = OW::getDbo()->queryForRow("SELECT * FROM `".OW_DB_PREFIX."base_plugin` WHERE `key` = '".$this->key."'");
        $name = OW::getConfig()->getValue("base", "site_name");

        $info["siteName"] = $name;
        $info["pluginId"] = $plugin["key"];
        $info["url"] = OW_URL_HOME;
        $info["licenseKey"] = $plugin["licenseKey"];
        $info["build"] = $plugin["build"];

        echo json_encode($info);
    }

    function uninstall()
    {

        $pluginService = BOL_PluginService::getInstance();
        $pluginDto = $pluginService->findPluginByKey($this->key);

        if ( $pluginDto === null )
        {
            echo json_encode(array("status" => "fail", "code" => 1, "message" => "not found"));
            exit;
        }

        if ( !$pluginDto->isActive )
        {
            $pluginService->activate($pluginDto->getKey());
        }

        try
        {
            $pluginService->uninstall($pluginDto->getKey());
        }
        catch ( Exception $e )
        {
            echo json_encode(array("status" => "fail", "code" => 2, "message" => $e->getMessage()));
            exit;
        }

        OW::getFeedback()->getFeedback();

        $availablePlugins = BOL_PluginService::getInstance()->getAvailablePluginsList();
        if ( !isset($availablePlugins[$this->key]) )
        {
            echo json_encode(array("status" => "fail", "code" => 3, "message" => $e->getMessage()));
            exit;
        }
        $dir = $availablePlugins[$this->key]["path"];

        try
        {
            $ftp = BOL_StorageService::getInstance()->getFtpConnection();
            $ftp->rmDir($dir);
        }
        catch ( Exception $e )
        {
            $resp = $this->delTree($dir);

            if($resp == true)
                echo json_encode(array("status" => "success"));
            else
                echo json_encode(array("status" => "fail", "code" => 4, "message" => $e->getMessage()));

            exit;
        }

        echo json_encode(array("status" => "success"));
        exit;
    }

    public function delTree($dir) {
        $files = array_diff(scandir($dir), array('.','..'));
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? $this->delTree("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    } 
}