<?php
/**
 * Copyright (c) 2015, Mike Gerst
 * All rights reserved.
 *
 * ATTENTION: This is licensed under the CC by-nd
 *
 * Full text of this license can be found at http://creativecommons.org/licenses/by-nd/3.0/legalcode
 */
 
class STATS_CLASS_PluginHandler
{
	public function activate($key)
    {
        $widgetHandler = STATS_CLASS_WidgetHandler::getInstance();
        
        $config = OW::getConfig();
        $activePlugins = json_decode($config->getValue('stats', 'activePlugins'));
        $plugins = $widgetHandler->getWidgets(true, true);
        
        if(in_array($key, $activePlugins)) return -1;
        
        if(!in_array($key, $plugins)) return 0;
        
        $widgetHandler->add($key);
        
        $activePlugins[] = $key;
        $config->saveConfig('stats', 'activePlugins', json_encode($activePlugins));
        
        $widgetHandler->initiateWidget($key);
        return 1;
    }
    
    public function deactivate($key)
    {
        $widgetHandler = STATS_CLASS_WidgetHandler::getInstance();
        
        $config = OW::getConfig();
        $plugins = json_decode($config->getValue('stats', 'activePlugins'));
        $new = array();
        
        foreach($plugins as $plugin)
            if($plugin != $key) $new[] = $plugin;
        
        $config->saveConfig('stats', 'activePlugins', json_encode($new));

        $widgetHandler->delete($key);
    }
}