<?php

class STATS_CLASS_Toolbox
{
    var $name;
    var $menuItems;
    var $dataItems;
    var $randId;

    public function __construct($key)
    {
        $this->name = $key;
        $this->randId = UTIL_HtmlTag::generateAutoId($key);
    }

    public function addItem($key, $label, $content, $active = false)
    {
        $contId = $this->randId."_users_widget_".$key;
        $toolbarId = false;

        $this->menuItems[$key] = array(
            'label' => $label,
            'id' => $this->randId."_toolbox_".$key,
            'contId' => $contId,
            'active' => $active, //count($this->dataItems) == 0 ? TRUE : FALSE,
            'toolbarId' => $toolbarId
        );

        $this->dataItems[$key] = array(
            'users' => $content,
            'active' => $active, //count($this->dataItems) == 0 ? TRUE : FALSE,
            'toolbar' => array(),
            'toolbarId' => $toolbarId,
            'contId' => $contId
        );
    }

    public function renderIt()
    {
        return array('menu' => new BASE_CMP_WidgetMenu($this->menuItems), 'data' => $this->dataItems, 'randId' => $this->randId);
    }
}