<?php

class STATS_CLASS_WidgetHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
            self::$classInstance = new self();

        return self::$classInstance;
    }

    public function getWidgets($all = false, $asList = false)
    {
        $widgets = array();
        
        $path = OW::getPluginManager()->getPlugin('stats')->getStaticDir().'widgets';
        $handle = opendir($path);
        $noPics = array('', '.', '..', '.htaccess');
        
        while ($file = readdir($handle))
        {
            if(in_array($file, $noPics)) continue;
            
            if($asList)
                $widgets[] = substr($file, 0, -5);
            else {
                $widget = $this->getWidget(substr($file, 0, -5));
                if($widget != null) $widgets[$widget->key] = $widget;
            }
        }
        
        if($all)
        {
            $event = new BASE_CLASS_EventCollector('stats.collectPlugins');
            OW::getEventManager()->trigger($event);
            
            foreach($event->getData() as $data)
            {
                if($asList)
                    $widgets[] = $data;
                else {
                    $widget = $this->getWidget($data);
                    if($widget != null) $widgets[$widget->key] = $widget;
                }
            }
        }
        
        return $widgets;
    }
    
    public function getWidget($key)
    {
        $event = new OW_Event('stats.getJSON', array('key' => $key));
        OW::getEventManager()->trigger($event);
        
        $widget = $this->parseWidgetJson($event->getData());
        return $widget;
    }
    
    public function parseWidgetJson($json)
    {
        if($json == null) return null;
        $data = json_decode($json);
        
        $widget = new STATS_CLASS_Widget($data->name, $data->place);
        $widget->name = $data->name;
        $widget->plugin = $data->plugin;
        $widget->key = $data->key;
        $widget->color = $data->color;
        $widget->isMobile = isset($data->mobile) ? $data->mobile : false;
        $widget->isClonable = isset($data->cloneable) ? $data->cloneable : false;
        $widget->dbTables = $data->dbTables;
        
        return $widget;
    }
    

    //Aktiviert ein Widget
    //param widget: XX_CLASS_Widget - Das Widget, das aktiviert werden soll
    public function add($key)
    {
        $widget = $this->getWidget($key);
        $widgetService = $widget->isMobile ? BOL_MobileWidgetService::getInstance() : BOL_ComponentAdminService::getInstance();

        $prefix = $widget->isMobile ? strtoupper($widget->plugin).'_MCMP_' : strtoupper($widget->plugin).'_CMP_';
        $temp = $widgetService->addWidget($prefix.$widget->name, $widget->isClonable);
        $placeWidget = $widgetService->addWidgetToPlace($temp, $widget->place);
        if($widget->position != '') $service->addWidgetToPosition($placeWidget, $widget->position, $widget->index);
    }

    //Aktiviert alle Widgets
    public function addAll()
    {
        $widgets = $this->getWidgets();
        $widgetService = BOL_ComponentAdminService::getInstance();
        $widgetServiceM = BOL_MobileWidgetService::getInstance();

        foreach($widgets as $widget)
        {
            $prefix = $widget->isMobile ? $this->pluginPrefix.'_MCMP_' : $this->pluginPrefix.'_CMP_';

            $temp = $widgetService->addWidget($prefix.$widget->name, $widget->isClonable);
            $placeWidget = $widgetService->addWidgetToPlace($temp, $widget->place);
            if($widget->position != '')
            {
                if($widget->isMobile) $widgetServiceM->addWidgetToPosition($placeWidget, $widget->position, $widget->index);
                else $widgetService->addWidgetToPosition($placeWidget, $widget->position, $widget->index);
            }
        }
    }

    //Deaktiviert ein Widget
    //param widget:   String  - Name des Widgets (ohne XX_CMP_XXXXX)
    //param isMobile: Boolean - Gibt an, ob es ein mobiles Widget ist
    public function delete($key, $isMobile = false)
    {
        $widget = $this->getWidget($key);
        if($widget == null) return;
        $prefix = $isMobile ? strtoupper($widget->plugin).'_MCMP_' : strtoupper($widget->plugin).'_CMP_';
        $service = $isMobile ? BOL_MobileWidgetService::getInstance() : BOL_ComponentAdminService::getInstance();
        $service->deleteWidget($prefix.$widget->name);
    }

    //Deaktiviert alle Widgets
    public function deleteAll()
    {
        $widgets = $this->getWidgets();
        $widgetService = BOL_ComponentAdminService::getInstance();
        $widgetServiceM = BOL_MobileWidgetService::getInstance();

        foreach($widgets as $widget)
        {
            $prefix = $widget->isMobile ? $this->pluginPrefix.'_MCMP_' : $this->pluginPrefix.'_CMP_';
            
            if($widget->isMobile) $widgetServiceM->deleteWidget($prefix.$widget->name);
            else $widgetService->deleteWidget($prefix.$widget->name);
        }
    }
    
    public function initiateWidget($key)
    {
        $timeStamp = time() - (3600*24*7);
        $event = new OW_Event('stats.getInitCount', array('key' => $key, 'time' => $timeStamp));
        OW::getEventManager()->trigger($event);
        
        $dao = STATS_BOL_StatisticDao::getInstance();
        $datas = $event->getData();
        
        foreach($datas as $entity => $data)
        {
            foreach($data['counts'] as $date => $count)
            {
                $dao->add($entity, $count, $date, $data['type']);
            }
        }
        
		$timestamp = time() - (3600*24);
        $timestring = date("Ymd", $timestamp);
        
        $dao = STATS_BOL_StatisticDao::getInstance();
        $widget = STATS_CLASS_WidgetHandler::getInstance()->getWidget($key);
        
        foreach($widget->dbTables as $table)
        {
            if(!$table->init) continue;
            
            $params = array();
            $params['key'] = $widget->key;
            $params['entity'] = $table->entity;
            $params['dateFrom'] = strtotime(date("m/d/Y", $timestamp));
            $params['dateTo'] = strtotime(date("m/d/Y", $timestamp)." + 1 day") -1;
            $params['date'] = isset($table->date) ? $table->date : 'date';
                
            $event = new OW_Event('stats.getCount', $params);
            OW::getEventManager()->trigger($event);
                
            $data = $event->getData();
                
            if($data != null)
                foreach($data as $type => $count)
                    if($count > 0) $dao->add($table->entity, $count, $timestring, $type);
        }
    }
}