<?php
/**
 * Copyright (c) 2015, Mike Gerst
 * All rights reserved.
 *
 * ATTENTION: This is licensed under the CC by-nd
 *
 * Full text of this license can be found at http://creativecommons.org/licenses/by-nd/3.0/legalcode
 */
 
class STATS_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function activate($params)
    {
        $key = $params['key'];
        $pluginHandler = new STATS_CLASS_PluginHandler();
        $state = $pluginHandler->activate($key);
        
        switch($state)
        {
            case -1:
                OW::getFeedback()->warning($this->text('activate_already_active', array('key' => $key)));
                break;
                
            case 0:
                OW::getFeedback()->error($this->text('activate_not_found', array('key' => $key)));
                break;
                
            case 1:
                OW::getFeedback()->info($this->text('activate_success', array('key' => $key)));
        }
        
        $this->redirect(OW::getRouter()->urlForRoute('stats.settings.plugins'));
        exit;
    }
    
    public function deactivate($params)
    {
        STATS_CLASS_PluginHandler::deactivate($params['key']);

        OW::getFeedback()->info($this->text('deactivate_success', array('key' => $key)));
        $this->redirect(OW::getRouter()->urlForRoute('stats.settings.plugins'));
        exit;
    }
    
    
    
    public function settings()
    {
        $title = $this->text('settings_title');
        $this->setPageTitle($title);
        $this->setPageHeading($title);
        
        $config = OW::getConfig();
        
        
        if(OW::getRequest()->isPost())
        {
            $config->saveConfig('stats', 'dayLimit', $_POST['dayLimit']);
            $config->saveConfig('stats', 'controleProblem', isset($_POST['controleProblem']));
            
            OW::getFeedback()->info($this->text('settings_saved'));
        }
        
        
        $form = new Form('settings');
        
        $val = new IntValidator();
        $val->setErrorMessage($this->text('settings_form_dayLimit_error'));
        $field = new TextField('dayLimit');
        $field->setLabel($this->text('settings_form_dayLimit_label'));
        $field->setDescription($this->text('settings_form_dayLimit_description'));
        $field->addValidator($val);
        $field->setValue($config->getValue('stats', 'dayLimit'));
        $form->addElement($field);
        
        $field = new CheckboxField('controleProblem');
        $field->setLabel($this->text('settings_form_controleProblem_label'));
        $field->setDescription($this->text('settings_form_controleProblem_description'));
        $field->setValue($config->getValue('stats', 'controleProblem'));
        $form->addElement($field);
        
        $field = new Submit('send');
        $form->addElement($field);
        
        $this->addForm($form);
    }
    
    public function plugins()
	{
        $title = $this->text('plugins_title');
        $this->setPageTitle($title);
        $this->setPageHeading($title);
        
        $pluginService = BOL_PluginService::getInstance();
        $router = OW::getRouter();
        
        $arrayToAssign['active'] = array();
        $arrayToAssign['inactive'] = array();
        $arrayToAssign['disabled'] = array();
        
        $expectedPlugins = array('users');
        $activePlugins = json_decode(OW::getConfig()->getValue('stats', 'activePlugins'));
        $plugins = STATS_CLASS_WidgetHandler::getInstance()->getWidgets(true);
        
        foreach($plugins as $plugin)
        {
            $regularPlugin = $pluginService->findPluginByKey($plugin->key);
            
            $event = new OW_Event('stats.getLanguageStrings', array('key' => $plugin->key));
            OW::getEventManager()->trigger($event);
            $langs = $event->getData();
            
            $array = array(
                'title' => $langs['title'],
                'description' => $langs['description'],
            );
            
            if(in_array($plugin->key, $expectedPlugins) || $regularPlugin != null && $regularPlugin->isActive)
            {
                if(in_array($plugin->key, $activePlugins)) {
                    $array['deact_url'] = $router->urlForRoute('stats.settings.deactivate', array('key' => $plugin->key));
                    $arrayToAssign['active'][$plugin->key] = $array;
                } else {
                    $array['active_url'] = $router->urlForRoute('stats.settings.activate', array('key' => $plugin->key));
                    $arrayToAssign['inactive'][$plugin->key] = $array;
                }
            } else {
                $arrayToAssign['disabled'][$plugin->key] = $array;
            }
        }
        
        $this->assign('plugins', $arrayToAssign);
	}
	
	public function panel()
	{
        $title = $this->text('dashboard_title');
        $this->setPageTitle($title);
        $this->setPageHeading($title);
        
        $place = 'stats.dashboard';
        $componentsService = BOL_ComponentAdminService::getInstance();
		$dbSettings = $componentsService->findAllSettingList();

        $dbPositions = $componentsService->findAllPositionList($place);

        $dbComponents = $componentsService->findPlaceComponentList($place);
        $activeScheme = $componentsService->findSchemeByPlace($place);
        $schemeList = $componentsService->findSchemeList();

        if ( empty($activeScheme) && !empty($schemeList) )
        {
            $activeScheme = reset($schemeList);
        }

        $componentPanel = new ADMIN_CMP_DragAndDropAdminPanel($place, $dbComponents, 'drag_and_drop_panel');
        $componentPanel->setPositionList($dbPositions);
        $componentPanel->setSettingList($dbSettings);
        $componentPanel->setSchemeList($schemeList);
        if ( !empty($activeScheme) )
        {
            $componentPanel->setScheme($activeScheme);
        }

        $this->assign('componentPanel', $componentPanel->render());
	}
    
    private function text($key, $params = null)
    {
        return OW::getLanguage()->text('stats', 'page_admin_'.$key, $params);
    }
}