<?php
	
class STATS_CTRL_Show extends OW_ActionController
{
	public function dashboard($paramList)
	{
                $title = $this->text('dash_title');
                $this->setPageTitle($title);
                $this->setPageHeading($title);
                
                if(!OW::getUser()->isAuthorized('stats', 'view_dashboard') && !OW::getUser()->isAuthorized('stats')) throw new Redirect403Exception();
                
                
                $this->assign('controleProblem', OW::getConfig()->getValue('stats', 'controleProblem'));
                
                
                
                $componentAdminService = BOL_ComponentAdminService::getInstance();
                $componentEntityService = BOL_ComponentEntityService::getInstance();
                
		$customizeMode = !empty($paramList['mode']) && $paramList['mode'] == 'customize';

                $place = 'stats.dashboard';
        
                $componentTemplate = $customizeMode ? 'drag_and_drop_entity_panel_customize' : 'drag_and_drop_entity_panel';
        
                $customizeUrls = array(
                'customize' => OW::getRouter()->urlForRoute('stats.dashboard.customize', array('mode' => 'customize')),
                'normal' => OW::getRouter()->urlForRoute('stats.dashboard')
                );
        
                $userId = OW::getUser()->getId();
        
                
                $userCustomizeAllowed = (bool) $componentAdminService->findPlace($place)->editableByUser;

                if ( !$userCustomizeAllowed && $customizeMode )
                {
                $this->redirect($customizeRouts['normal']);
                }
        
                $schemeList = $componentAdminService->findSchemeList();
        
                $state = $componentAdminService->findCache($place);
                if ( empty($state) )
                {
                $state = array();
                $state['defaultComponents'] = $componentAdminService->findPlaceComponentList($place);
                $state['defaultPositions'] = $componentAdminService->findAllPositionList($place);
                $state['defaultSettings'] = $componentAdminService->findAllSettingList();
                $state['defaultScheme'] = (array) $componentAdminService->findSchemeByPlace($place);
        
                $componentAdminService->saveCache($place, $state);
                }
        
                $defaultComponents = $state['defaultComponents'];
                $defaultPositions = $state['defaultPositions'];
                $defaultSettings = $state['defaultSettings'];
                $defaultScheme = $state['defaultScheme'];
        
                if ( $userCustomizeAllowed )
                {
                $userCache = $componentEntityService->findEntityCache($place, $userId);
        
                if ( empty($userCache) )
                {
                        $userCache = array();
                        $userCache['userComponents'] = $componentEntityService->findPlaceComponentList($place, $userId);
                        $userCache['userSettings'] = $componentEntityService->findAllSettingList($userId);
                        $userCache['userPositions'] = $componentEntityService->findAllPositionList($place, $userId);
        
                        $componentEntityService->saveEntityCache($place, $userId, $userCache);
                }
        
                $userComponents = $userCache['userComponents'];
                $userSettings = $userCache['userSettings'];
                $userPositions = $userCache['userPositions'];
                }
                else
                {
                $userComponents = array();
                $userSettings = array();
                $userPositions = array();
                }
        
                if ( empty($defaultScheme) && !empty($schemeList) )
                {
                $defaultScheme = reset($schemeList);
                }
        
                $componentPanel = new BASE_CMP_DragAndDropEntityPanel($place, $userId, $defaultComponents, $customizeMode, $componentTemplate, null);
                $componentPanel->setAdditionalSettingList(array(
                'entityId' => $userId,
                'entity' => 'user'
                ));
        
                if ( !empty($customizeRouts) )
                {
                $componentPanel->allowCustomize($userCustomizeAllowed);
                $componentPanel->customizeControlCunfigure($customizeRouts['customize'], $customizeRouts['normal']);
                }
        
                $componentPanel->setSchemeList($schemeList);
                $componentPanel->setPositionList($defaultPositions);
                $componentPanel->setSettingList($defaultSettings);
                $componentPanel->setScheme($defaultScheme);
        
                /*
                * This feature was disabled for users
                * if ( !empty($userScheme) )
                {
                $componentPanel->setEntityScheme($userScheme);
                } */
        
                if ( !empty($userComponents) )
                {
                $componentPanel->setEntityComponentList($userComponents);
                }
        
                if ( !empty($userPositions) )
                {
                $componentPanel->setEntityPositionList($userPositions);
                }
        
                if ( !empty($userSettings) )
                {
                $componentPanel->setEntitySettingList($userSettings);
                }
        
                $this->assign('componentPanel', $componentPanel->render());
	}
        
        
        
        public function text($key)
        {
                return OW::getLanguage()->text('stats', 'page_show_'.$key);
        }
}