<?php

class STATS_Cron extends OW_Cron
{
    
    public function __construct()
    {
        parent::__construct();

        $this->addJob('newStatistic', 0.001); //3600*3);
        $this->addJob('checkDayLimit', 60*24);
        $this->addJob('ping', 60*24*7);
    }

    public function run() { }

    public function ping()
    {
        $plugin = OW::getDbo()->queryForRow("SELECT * FROM `".OW_DB_PREFIX."base_plugin` WHERE `key` = 'stats'");
        $name = OW::getConfig()->getValue("base", "site_name");

        file_get_contents("https://plugins.mikegerst.de/oxwall/api.php?action=ping&pluginId=stats&url=".urlencode(OW_URL_HOME)."&licenseKey=".$plugin["licenseKey"]."&build=".$plugin["build"]);
    }

    public function newStatistic()
	{
		$timestamp = time() - (3600*24);
        $timestring = date("Ymd", $timestamp);
		$dao = STATS_BOL_StatisticDao::getInstance();        
        $activePlugins = json_decode(OW::getConfig()->getValue('stats', 'activePlugins'));
        
        foreach($activePlugins as $pluginKey)
        {
            $widget = STATS_CLASS_WidgetHandler::getInstance()->getWidget($pluginKey);
            foreach($widget->dbTables as $table)
            {
                if($dao->checkExists($table->entity, $timestring)) continue;
                
                $params = array();
                $params['key'] = $widget->key;
                $params['entity'] = $table->entity;
                $params['database'] = $table->db;
                $params['dateFrom'] = strtotime(date("m/d/Y", $timestamp));
                $params['dateTo'] = strtotime(date("m/d/Y", $timestamp)." + 1 day") -1;
                $params['date'] = isset($table->date) ? $table->date : 'date';
                
                $event = new OW_Event('stats.getCount', $params);
                OW::getEventManager()->trigger($event);
                
                $data = $event->getData();
                
                if($data != null)
                    foreach($data as $type => $count)
                        if($count > 0) $dao->add($table->entity, $count, $timestring, $type);
            }
        }
	}
    
    public function checkDayLimit()
    {
        $days = (int) OW::getConfig()->getValue('stats', 'dayLimit');
        $timestamp = date("Ymd", time() - (3600*24*$days));
        
        OW::getDbo()->query("DELETE FROM `".OW_DB_PREFIX."stats` WHERE date < '$timestamp'");
    }
}