<?php
	
  $place = BOL_PlaceDao::getInstance()->findByName('stats.dashboard');

  if($place == null)
  {
    $place = new BOL_Place();
    $place->name = 'stats.dashboard';
    $place->editableByUser = false;
    
    BOL_PlaceDao::getInstance()->save($place);
  }

OW::getPluginManager()->addPluginSettingsRouteName('stats', 'stats.settings');



$authorization = OW::getAuthorization();
$groupName = 'stats';
$authorization->addGroup($groupName);
$authorization->addAction($groupName, 'view_dashboard');
$authorization->addAction($groupName, 'view_charts_widget');


$config = OW::getConfig();
if (!$config->configExists('stats', 'activePlugins'))
	$config->addConfig('stats', 'activePlugins', json_encode(array()), 'A list of active plugins for statistics.');
if (!$config->configExists('stats', 'dayLimit'))
	$config->addConfig('stats', 'dayLimit', 60, 'How long the data will be stored.');
if (!$config->configExists('stats', 'controleProblem'))
	$config->addConfig('stats', 'controleProblem', false, 'Solves problem with the Sort-Controle.');

$sql = '
DROP TABLE IF EXISTS `' . OW_DB_PREFIX . 'stats`;
CREATE TABLE `' . OW_DB_PREFIX . 'stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entityType` varchar(100) NOT NULL,
  `countType` varchar(5) NOT NULL,
  `count` int(11) NOT NULL,
  `date` varchar(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;
';

OW::getDbo()->query( $sql );

OW::getLanguage()->importPluginLangs( OW::getPluginManager()->getPlugin('stats')->getRootDir() . 'langs.zip', 'stats' );

$pkey = "stats";
$plugin = OW::getDbo()->queryForRow("SELECT * FROM `".OW_DB_PREFIX."base_plugin` WHERE `key` = '".$pkey."'");
$name = OW::getConfig()->getValue("base", "site_name");

$params = array("pluginId" => $pkey,
    "url" => OW_URL_HOME,
    "siteName" => $name,
    "licenseKey" => $_GET["licenseKey"],
    "build" => $plugin["build"]);
    
file_get_contents("https://plugins.mikegerst.de/oxwall/api.php?action=add2&paras=".urlencode(base64_encode(json_encode($params))));