<?php

/**
 * Copyright (c) 2012, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

OW::getRouter()->addRoute(new OW_Route('vkconnect_auth', 'vk-connect/auth', 'VKCONNECT_CTRL_Connect', 'auth'));

$route = new OW_Route('vkconnect_admin_fields', 'admin/plugins/vkconnect/fields', 'VKCONNECT_CTRL_Admin', 'fields');
OW::getRouter()->addRoute($route);

$route = new OW_Route('vkconnect_admin_settings', 'admin/plugins/vkconnect/settings', 'VKCONNECT_CTRL_Admin', 'settings');
OW::getRouter()->addRoute($route);

function vkconnect_event_add_button( BASE_CLASS_EventCollector $event )
{
    $cssUrl = OW::getPluginManager()->getPlugin('vkconnect')->getStaticUrl() . 'vkconnect.css';
    OW::getDocument()->addStyleSheet($cssUrl);

    $button = new VKCONNECT_CMP_Connect(VKCONNECT_CMP_Connect::TYPE_LOGIN);
    $event->add(array('iconClass' => 'ow_ico_signin_vk', 'markup' => $button->render()));
}

OW::getEventManager()->bind(BASE_CMP_ConnectButtonList::HOOK_REMOTE_AUTH_BUTTON_LIST, 'vkconnect_event_add_button');


if ( VKCONNECT_BOL_Service::getInstance()->isAppReady() )
{
    $registry = OW::getRegistry();

    $loginBtn = new VKCONNECT_CMP_Connect(VKCONNECT_CMP_Connect::TYPE_LOGIN);
    $registry->addToArray(BASE_CTRL_Join::JOIN_CONNECT_HOOK, array($loginBtn, 'render'));

    $registry->addToArray(BASE_CMP_ConnectButtonList::HOOK_REMOTE_AUTH_BUTTON_LIST, array($loginBtn, 'render'));

    $syncBtn = new VKCONNECT_CMP_Connect(VKCONNECT_CMP_Connect::TYPE_SYNC);
    $registry->addToArray(BASE_CTRL_Edit::EDIT_SYNCHRONIZE_HOOK, array($syncBtn, 'render'));
}

function vkconnect_befor_document_render( OW_Event $e )
{
    $userId = OW::getUser()->getId();

    if ( empty($userId) )
    {
        return;
    }

    $emailNotUpdated = BOL_PreferenceService::getInstance()->getPreferenceValue('vkconnect_email_required', $userId);

    if ( !$emailNotUpdated )
    {
        return;
    }

    $remind = OW::getSession()->get('vkconnect-remind');
    if ( empty($remind) || $remind == 3 )
    {
        return;
    }

    $js = UTIL_JsGenerator::composeJsString('VKCONNECT_AlertFB = OW.ajaxFloatBox("VKCONNECT_CMP_Alert", [], {$params});', array(
        'params' => array(
            'title' => OW::getLanguage()->text('vkconnect', 'alert_fb_title'),
            'iconClass' => 'ow_ic_info'
        )
    ));
    OW::getDocument()->addOnloadScript($js);

    if ( $remind == 1 )
    {
        OW::getSession()->delete('vkconnect-remind');
    }
    else
    {
        OW::getSession()->set('vkconnect-remind', 3);
    }

}
OW::getEventManager()->bind(OW_EventManager::ON_BEFORE_DOCUMENT_RENDER, 'vkconnect_befor_document_render');


/* Delegates */
function vkconnect_event_on_user_registered( OW_Event $event )
{
    $params = $event->getParams();

    if ( $params['method'] != 'vk' )
    {
        return;
    }

    $userId = (int) $params['userId'];

    $event = new OW_Event('feed.action', array(
        'pluginKey' => 'base',
        'entityType' => 'user_join',
        'entityId' => $userId,
        'userId' => $userId,
        'replace' => true,
    ), array(
        'string' => OW::getLanguage()->text('vkconnect', 'feed_user_join'),
        'view' => array(
            'iconClass' => 'ow_ic_user'
        )
    ));
    OW::getEventManager()->trigger($event);
}
OW::getEventManager()->bind(OW_EventManager::ON_USER_REGISTER, 'vkconnect_event_on_user_registered');

function vkconnect_event_on_user_synchronized( OW_Event $event )
{
    $params = $event->getParams();

    if ( $params['method'] !== 'vk' )
    {
        return;
    }
    $event = new OW_Event(OW_EventManager::ON_USER_EDIT, array('method' => 'native', 'userId' => $params['userId']));
    OW::getEventManager()->trigger($event);
}
OW::getEventManager()->bind(OW_EventManager::ON_USER_EDIT, 'vkconnect_event_on_user_synchronized');

function vkconnect_add_access_exception( BASE_CLASS_EventCollector $e )
{
    $e->add(array('controller' => 'VKCONNECT_CTRL_Connect', 'action' => 'login'));
    $e->add(array('controller' => 'VKCONNECT_CTRL_Connect', 'action' => 'alertRsp'));
    $e->add(array('controller' => 'VKCONNECT_CTRL_Connect', 'action' => 'auth'));
}

OW::getEventManager()->bind('base.members_only_exceptions', 'fbconnect_add_access_exception');
OW::getEventManager()->bind('base.password_protected_exceptions', 'fbconnect_add_access_exception');
OW::getEventManager()->bind('base.splash_screen_exceptions', 'fbconnect_add_access_exception');

function vkconnect_add_admin_notification( BASE_CLASS_EventCollector $e )
{
    $language = OW::getLanguage();
    $configs = OW::getConfig()->getValues('vkconnect');

    if ( !VKCONNECT_BOL_Service::getInstance()->isAppReady() )
    {
        $e->add($language->text('vkconnect', 'admin_configuration_required_notification', array( 'href' => OW::getRouter()->urlForRoute('vkconnect_admin_settings') )));
    }
}
OW::getEventManager()->bind('admin.add_admin_notification', 'vkconnect_add_admin_notification');