<?php
	class TOPLINK_CTRL_Admin extends ADMIN_CTRL_Abstract{
		
		public $iconDir;
		private $iMagicInstalled;
		
		public function __construct(){
			parent::__construct();
			
			$this->setPageTitle($this->text('toplink', 'index_page_title'));
			$this->setPageHeading($this->text('toplink', 'index_page_title'));
			$this->setPageHeadingIconClass('ow_ic_star');
			
			$this->iconDir = OW_DIR_PLUGIN_USERFILES . 'toplink' . DS;
			
			OW::getNavigation()->activateMenuItem('admin_plugins', 'admin', 'sidebar_menu_plugins_installed');
		}
		
		public function index(){}
		
		public function toplinklist(){
			OW::getDocument()->addStyleSheet( OW::getPluginManager()->getPlugin('toplink')->getStaticCssUrl().'style.css' );
			
			$currId = @$_GET['id'];
			$topForm = new Form("topForm");
			$topForm->setEnctype('multipart/form-data');
			$topSubmit = new Submit("topSubmit");
			$topForm->addElement( $topSubmit );
			
			$topName = new TextField("topName");
			$topUrl = new TextField("topUrl");
			$topIcon = new TextField("topIcon");
			$topId = new HiddenField("topId");
			
			$uploadIcon = new FileField('topIconFile');
			$uploadIcon->setLabel( $this->text( 'toplink', 'new_icon' ) );
			
			$topOrder = new TextField('toporder');
			$topOrder->setLabel( $this->text( 'toplink', 'new_order' ) );
			
			$topTarget = new CheckboxField('toptarget');
			$topTarget->setLabel( $this->text( 'toplink', 'new_target' ) );
			
			$topName->setLabel( $this->text( 'toplink', 'new_name' ) );
			$topUrl->setLabel( $this->text( 'toplink', 'new_url' ) );
			$topIcon->setLabel( $this->text( 'toplink', 'new_icon' ) );
			
			if( !empty( $currId ) && !OW::getRequest()->isPost() ){
				$theTopLink = TOPLINK_BOL_Service::getInstance()->getTopLinkById( $currId );
				
				$topName->setValue( $theTopLink->itemname );
				$topId->setValue( $currId );
				$topUrl->setValue( $theTopLink->url );
				$topIcon->setValue( $theTopLink->icon );
				$topTarget->setValue( $theTopLink->target );
				$topOrder->setValue( $theTopLink->order );
			}
			
			$topForm->addElement( $topName );
			$topForm->addElement( $topUrl );
			$topForm->addElement( $topIcon );
			$topForm->addElement( $topId );
			$topForm->addElement( $topTarget );
			$topForm->addElement( $topOrder );
			$topForm->addElement( $uploadIcon );
			$this->addForm( $topForm );
			
			if( OW::getRequest()->isPost() ){
				if( $topForm->isValid( $_POST ) ){
					$fdata = $topForm->getValues();
					$newtoplink = new TOPLINK_BOL_Toplink();
					$newtoplink->id = $fdata['topId'];
					$newtoplink->itemname = $fdata['topName'];
					$theurl = $fdata['topUrl'];
					$newtoplink->url = $fdata['topUrl'];
					$newtoplink->icon = $fdata['topIcon'];
					$newtoplink->target = $fdata['toptarget'];
					$newtoplink->order = empty( $fdata['toporder'] ) ? 5 : $fdata['toporder'];
					
					$loadedExts = get_loaded_extensions();
					if( in_array( 'imagick', $loadedExts ) ){
						$this->iMagicInstalled = true;
					}
					
					if( $_FILES['topIconFile']['error'] == 0 ){
						$ext = explode( '.', $_FILES['topIconFile']['name'] );
						$ext = end( $ext );
						if( $this->iMagicInstalled ){
							$image = new Imagick( $_FILES['topIconFile']['tmp_name'] );
							$image->thumbnailImage( 16, 0);
							file_put_contents( $this->iconDir . $_FILES['topIconFile']['name'].'.png', $image );
							$uploadresult = $_FILES['topIconFile']['name'].'.png';
						}else{
							$uploadresult = $this->generateThumb( $_FILES['topIconFile']['tmp_name'], $ext, $_FILES['topIconFile']['name'] );
						}
						
						if( $uploadresult ){
							$newtoplink->icon = "/".$uploadresult;
						}
					}
					
					TOPLINK_BOL_Service::getInstance()->saveToplink( $newtoplink );
					OW::getFeedback()->info($this->text('toplink', 'save_success_message'));
				}
			}
			
			$alltoplink = TOPLINK_BOL_Service::getInstance()->getTopLink();
			
			$this->assign( 'updatelink', OW::getRouter()->urlForRoute( 'toplink.admin' ) );
			$this->assign( 'removelink', OW::getRouter()->urlForRoute( 'toplink.remove' ) );
			$this->assign( 'alltoplink', $alltoplink );
		}
		
		public function removelink(){
			$id = $_GET['id'];
			TOPLINK_BOL_Service::getInstance()->removeToplink( $id );
			OW::getFeedback()->info($this->text('toplink', 'toplink_removed'));
			$this->redirect( OW::getRouter()->urlFor( 'TOPLINK_CTRL_Admin', 'toplinklist' ) );
		}
		
		private function text( $prefix, $key, array $vars = null ){
			return OW::getLanguage()->text( $prefix, $key, $vars );
		}
		
		/* -- image uploads -- */
		private function generateThumb( $tempFileName, $extension, $stdName ){
			
			list( $width,$height ) = getimagesize( $tempFileName );
			$thumbSmall = $this->resizeImage( $width, $height, 16 );
			
			$thumbNameSmall = $stdName;
			$tempImageSmall = imagecreatetruecolor( $thumbSmall['width'],$thumbSmall['height'] );
			/* imagecolorallocatealpha($tempImageSmall, 255, 255, 255, 75); */
			
			if( $extension == 'jpg' || $extension == 'jpeg' ){
				$imgResource = imagecreatefromjpeg( $tempFileName );
			}elseif( $extension == 'gif' ){
				$imgResource = imagecreatefromgif( $tempFileName );
				imagecolortransparent($imgResource, imagecolorallocatealpha($imgResource, 0, 0, 0, 127));
				imagealphablending($imgResource, false);
				imagesavealpha($imgResource, true);
			}elseif( $extension == 'png' ){
				$imgResource = imagecreatefrompng( $tempFileName );
				imagecolortransparent($imgResource, imagecolorallocatealpha($imgResource, 0, 0, 0, 127));
				imagealphablending($imgResource, false);
				imagesavealpha($imgResource, true);
			}elseif( $extension == 'bmp' ){
				$imgResource = self::imagecreatefrombmp( $tempFileName );
				$extension = 'jpg'; /* thumb for bitmap type image is jpg type */
			}
			
			/* small thumb */
			imagecopyresampled( $tempImageSmall,$imgResource,0,0,0,0,$thumbSmall['width'],$thumbSmall['height'],$width,$height );
			imagepng( $tempImageSmall,$thumbNameSmall );
			imagedestroy( $imgResource );
			
			if( $renres = rename( $thumbNameSmall, $this->iconDir . $thumbNameSmall.'.png' ) ){
				return $thumbNameSmall.'.png';
			}
			return false;
		}
		
		private function resizeImage( $width, $height, $thumbSize ){
			if( $width > $height ){
				$newwidth = ( $width > $thumbSize ) ? $thumbSize : $width;
				$newheight = ( $newwidth / $width ) * $height;
			}elseif( $height > $width ){
				$newheight = ( $height > $thumbSize ) ? $thumbSize : $height;
				$newwidth = ( $newheight / $height ) * $width;
			}else{
				if( $height > $thumbSize || $width > $thumbSize ){
					$newheight = $thumbSize;
					$newwidth = $thumbSize;
				}else{
					$newheight = $height;
					$newwidth = $width;
				}
			}
			return array(
				'height' => $newheight,
				'width' => $newwidth
			);
		}
		
		private function ConvertBMP2GD( $src,$dest = false ){
			if( !( $src_f = fopen( $src, "rb" ) ) ){
				return false;
			}
			
			if( !( $dest_f = fopen( $dest, "wb" ) ) ){
				return false;
			}
	 
			$header = unpack( "vtype/Vsize/v2reserved/Voffset", fread( $src_f,14 ) );
			$info = unpack( "Vsize/Vwidth/Vheight/vplanes/vbits/Vcompression/Vimagesize/Vxres/Vyres/Vncolor/Vimportant", fread( $src_f, 40 ) );

			extract($info);
			extract($header);
			
			if( $type != 0x4D42 ){ /* signature "BM" */
				return false;
			}
			
			$palette_size = $offset - 54;
			$ncolor = $palette_size / 4;
			$gd_header = "";

			/* true-color vs. palette */
			$gd_header .= ( $palette_size == 0 ) ? "\xFF\xFE" : "\xFF\xFF";
			$gd_header .= pack( "n2", $width, $height );
			$gd_header .= ( $palette_size == 0 ) ? "\x01" : "\x00";
			
			if( $palette_size ){
				$gd_header .= pack( "n", $ncolor );
			}
		
			/* no transparency */
			$gd_header .= "\xFF\xFF\xFF\xFF";

			fwrite( $dest_f, $gd_header );

			if( $palette_size ){
				$palette = fread( $src_f, $palette_size );
				$gd_palette = "";
				$j = 0;
	  
				while( $j < $palette_size ){
					$b = $palette{ $j++ };
					$g = $palette{ $j++ };
					$r = $palette{ $j++ };
					$a = $palette{ $j++ };
					$gd_palette .= "$r$g$b$a";
				}

				$gd_palette .= str_repeat( "\x00\x00\x00\x00", 256 - $ncolor );
				fwrite( $dest_f, $gd_palette );
			}

			$scan_line_size = ( ( $bits * $width ) + 7 ) >> 3;
			$scan_line_align = ( $scan_line_size & 0x03 ) ? 4 - ( $scan_line_size &0x03 ) : 0;
			
			for( $i = 0, $l = $height - 1; $i < $height; $i++, $l-- ){
				/* BMP stores scan lines starting from bottom */
				fseek( $src_f, $offset + ( ( $scan_line_size + $scan_line_align ) * $l ) );
				$scan_line = fread( $src_f, $scan_line_size );
			
				if( $bits == 24 ){
					$gd_scan_line = "";
					$j = 0;
					while( $j < $scan_line_size ){
						$b = $scan_line{$j++};
						$g = $scan_line{$j++};
						$r = $scan_line{$j++};
						$gd_scan_line .= "\x00$r$g$b";
					}
				}elseif( $bits == 8 ){
					$gd_scan_line = $scan_line;
				}elseif( $bits == 4 ){
					$gd_scan_line = "";
					$j = 0;
					while( $j < $scan_line_size ){
						$byte = ord( $scan_line{ $j++ } );
						$p1 = chr( $byte >> 4 );
						$p2 = chr( $byte & 0x0F );
						$gd_scan_line .= "$p1$p2";
					}
					$gd_scan_line = substr( $gd_scan_line, 0, $width );
				}elseif( $bits == 1 ){
					$gd_scan_line = "";
					$j = 0;
					while( $j < $scan_line_size ){
						$byte = ord( $scan_line{ $j++ } );
						$p1 = chr( (int) ( ( $byte & 0x80 ) != 0 ) );
						$p2 = chr( (int) ( ( $byte & 0x40 ) != 0 ) );
						$p3 = chr( (int) ( ( $byte & 0x20 ) != 0 ) );
						$p4 = chr( (int) ( ( $byte & 0x10 ) != 0 ) );
						$p5 = chr( (int) ( ( $byte & 0x08 ) != 0 ) );
						$p6 = chr( (int) ( ( $byte & 0x04 ) != 0 ) );
						$p7 = chr( (int) ( ( $byte & 0x02 ) != 0 ) );
						$p8 = chr( (int) ( ( $byte & 0x01 ) != 0 ) );
						$gd_scan_line .= "$p1$p2$p3$p4$p5$p6$p7$p8";
					} 				
					$gd_scan_line = substr( $gd_scan_line, 0, $width );
				}
				fwrite( $dest_f, $gd_scan_line );
			}
			fclose($src_f);
			fclose($dest_f);
			return true;
		}

		private function imagecreatefrombmp( $filename ){
			$tmp_name = tempnam( "/tmp", "GD" );
			if( self::ConvertBMP2GD( $filename, $tmp_name ) ){
				$img = imagecreatefromgd( $tmp_name );
				unlink($tmp_name);
				return $img;
			}
			return false;
		}
		/* -- image uploads -- */
	}
?>