<?php
final class TOPLINK_BOL_Service{
    private function __construct(){}
    private static $classInstance;

    public static function getInstance(){
        if ( self::$classInstance === null ){
            self::$classInstance = new self();
        }
        return self::$classInstance;
    }
	
	public function getToplink(){
		return TOPLINK_BOL_ToplinkDao::getInstance()->findAll();
	}
	
	public function getTopLinkById( $id ){
		return TOPLINK_BOL_ToplinkDao::getInstance()->findById( $id );
	}
	
    public function saveToplink( TOPLINK_BOL_Toplink $toplinkitems ){
		TOPLINK_BOL_ToplinkDao::getInstance()->save( $toplinkitems );
    }

    public function removeToplink( $id ){
		$thistoplink = $this->getTopLinkById( $id );
		$iconfile = $thistoplink->icon;
		if( preg_match( '/^\//', $iconfile ) ){
			$avatarService = BOL_AvatarService::getInstance();
			$avatarService->removeAvatarImage( $avatarService->getAvatarsDir() . preg_replace( '/^\//','',$iconfile ) );
		}
        TOPLINK_BOL_ToplinkDao::getInstance()->deleteById( $id );
    }
}