<?php
	class TOPLINK_CLASS_EventHandler{
		private static $classInstance;
		
		public static function getInstance(){
			if ( !isset(self::$classInstance) ){
				self::$classInstance = new self();
			}
			return self::$classInstance;
		}
		
		public function collectItems( BASE_CLASS_ConsoleItemCollector $event ){
			if (OW::getUser()->isAuthenticated()){
			
				$toplinks = TOPLINK_BOL_Service::getInstance()->getToplink();
				if( !empty( $toplinks ) ){
					foreach( $toplinks as $toplink ){
						$item = new BASE_CMP_ConsoleItem();
						$toplink->icon = preg_match( '/^\//',$toplink->icon ) ? OW::getPluginManager()->getPlugin('base')->getUserFilesUrl() . 'avatars' . $toplink->icon : $toplink->icon;
						
						$template = OW::getPluginManager()->getPlugin('toplink')->getCmpViewDir() . 'top_link_item.html';
						$item->setTemplate($template);
						$item->setContent( array(
							'name' => $toplink->itemname,
							'icon' => $toplink->icon,
							'url' => $toplink->url,
							'target' => $toplink->target
						) );
						
						$event->addItem($item, $toplink->order);
					}
				}
			}
		}
		
		public function init(){
			OW::getEventManager()->bind('console.collect_items', array($this, 'collectItems'));
		}
	}
?>