<?php
	class TOPLINK_CTRL_Admin extends ADMIN_CTRL_Abstract{
		
		public $iconDir;
		private $iMagicInstalled;
		
		public function __construct(){
			parent::__construct();
			
			$this->setPageTitle($this->text('toplink', 'index_page_title'));
			$this->setPageHeading($this->text('toplink', 'index_page_title'));
			$this->setPageHeadingIconClass('ow_ic_star');
			
			$this->iconDir = BOL_AvatarService::getInstance()->getAvatarsDir();
			
			OW::getNavigation()->activateMenuItem('admin_plugins', 'admin', 'sidebar_menu_plugins_installed');
		}
		
		public function index(){}
		
		public function toplinklist(){
			OW::getDocument()->addStyleSheet( OW::getPluginManager()->getPlugin('toplink')->getStaticCssUrl().'style.css' );
			
			$currId = @$_GET['id'];
			$topForm = new Form("topForm");
			$topForm->setEnctype('multipart/form-data');
			$topSubmit = new Submit("topSubmit");
			$topForm->addElement( $topSubmit );
			
			$topName = new TextField("topName");
			$topUrl = new TextField("topUrl");
			$topIcon = new TextField("topIcon");
			$topId = new HiddenField("topId");
			
			$uploadIcon = new FileField('topIconFile');
			$uploadIcon->setLabel( $this->text( 'toplink', 'new_icon' ) );
			
			$topOrder = new TextField('toporder');
			
			$topTarget = new CheckboxField('toptarget');
			
			$topOrder->setLabel( $this->text( 'toplink', 'new_order' ) );
			$topOrder->setRequired();
			$topTarget->setLabel( $this->text( 'toplink', 'new_target' ) );
			$topName->setLabel( $this->text( 'toplink', 'new_name' ) );
			$topName->setRequired();
			$topUrl->setLabel( $this->text( 'toplink', 'new_url' ) );
			$topUrl->setRequired();
			$topIcon->setLabel( $this->text( 'toplink', 'new_icon' ) );
			
			if( !empty( $currId ) && !OW::getRequest()->isPost() ){
				$theTopLink = TOPLINK_BOL_Service::getInstance()->getTopLinkById( $currId );
				
				$topName->setValue( $theTopLink->itemname );
				$topId->setValue( $currId );
				$topUrl->setValue( $theTopLink->url );
				$topIcon->setValue( $theTopLink->icon );
				$topTarget->setValue( $theTopLink->target );
				$topOrder->setValue( $theTopLink->order );
			}
			
			$topForm->addElement( $topName );
			$topForm->addElement( $topUrl );
			$topForm->addElement( $topIcon );
			$topForm->addElement( $topId );
			$topForm->addElement( $topTarget );
			$topForm->addElement( $topOrder );
			$topForm->addElement( $uploadIcon );
			$this->addForm( $topForm );
			
			if( OW::getRequest()->isPost() ){
				if( $topForm->isValid( $_POST ) ){
					$fdata = $topForm->getValues();
					$newtoplink = new TOPLINK_BOL_Toplink();
					$newtoplink->id = $fdata['topId'];
					$newtoplink->itemname = $fdata['topName'];
					
					$theurl = $fdata['topUrl'];
					if( !empty( $theurl ) ){
						$theurl = preg_match( "/^http:\/\//",$theurl ) ? $theurl : "http://".$theurl;
					}else{
						$theurl = "#";
					}
					
					$newtoplink->url = $theurl;
					
					/* check file exist */
					if( !empty( $fdata['topIcon'] ) && preg_match( "/^\//",$fdata['topIcon'] ) ){
						$newtoplink->icon = $fdata['topIcon'];
						$iconFileName = preg_replace( "/^\//" , "" , $newtoplink->icon );
						if( !file_exists( $this->iconDir . $iconFileName ) ){
							$newtoplink->icon = null;
						}
					}
					/* end */
					
					$newtoplink->target = $fdata['toptarget'];
					$newtoplink->order = empty( $fdata['toporder'] ) ? 5 : $fdata['toporder'];
					
					$loadedExts = get_loaded_extensions();
					if( in_array( 'imagick', $loadedExts ) ){
						$this->iMagicInstalled = true;
					}
					
					if( $_FILES['topIconFile']['error'] == 0 ){
						$ext = explode( '.', $_FILES['topIconFile']['name'] );
						$ext = end( $ext );
						
						if( $this->iMagicInstalled ){
							$image = new Imagick( $_FILES['topIconFile']['tmp_name'] );
							$image->thumbnailImage( 16, 0);
							
							file_put_contents( $this->iconDir . $_FILES['topIconFile']['name'].'.png', $image );
							
							$uploadresult = $_FILES['topIconFile']['name'].'.png';
						}else{
							try{
								$image = new UTIL_Image($_FILES['topIconFile']['tmp_name'], 'PNG');
								$image->resizeImage(16, 16, false)
									->saveImage( $this->iconDir . $_FILES['topIconFile']['name'].'.png' );
								
								$uploadresult = $_FILES['topIconFile']['name'].'.png';
							}catch(Exception $e){
								$uploadresult = null;
							}
						}
						
						
						if( $uploadresult ){
							$newtoplink->icon = "/".$uploadresult;
						}
						
						/* check file exist AGAIN AFTER UPLOAD */
						if( $newtoplink->icon && preg_match( "/^\//",$newtoplink->icon ) ){
							$iconFileName = preg_replace( "/^\//" , "" , $newtoplink->icon );
							if( !file_exists( $this->iconDir . $iconFileName ) ){
								$newtoplink->icon = null;
							}
						}
						/* end */
					}
					
					TOPLINK_BOL_Service::getInstance()->saveToplink( $newtoplink );
					OW::getFeedback()->info($this->text('toplink', 'save_success_message'));
				}
			}
			
			$alltoplink = TOPLINK_BOL_Service::getInstance()->getTopLink();
			
			$this->assign( 'updatelink', OW::getRouter()->urlForRoute( 'toplink.admin' ) );
			$this->assign( 'removelink', OW::getRouter()->urlForRoute( 'toplink.remove' ) );
			$this->assign( 'alltoplink', $alltoplink );
		}
		
		public function removelink(){
			$id = $_GET['id'];
			TOPLINK_BOL_Service::getInstance()->removeToplink( $id );
			OW::getFeedback()->info($this->text('toplink', 'toplink_removed'));
			$this->redirect( OW::getRouter()->urlFor( 'TOPLINK_CTRL_Admin', 'toplinklist' ) );
		}
		
		private function text( $prefix, $key, array $vars = null ){
			return OW::getLanguage()->text( $prefix, $key, $vars );
		}
		
	}
?>