<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 *
 * @author Sergey Kambalin <greyexpert@gmail.com>
 * @package fgift.bol
 */
class FGIFT_BOL_GiftDao extends OW_BaseDao
{
    /**
     * Singleton instance.
     *
     * @var FGIFT_BOL_GiftDao
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return FGIFT_BOL_GiftDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     * @see OW_BaseDao::getDtoClassName()
     *
     */
    public function getDtoClassName()
    {
        return 'FGIFT_BOL_Gift';
    }

    /**
     * @see OW_BaseDao::getTableName()
     *
     */
    public function getTableName()
    {
        return OW_DB_PREFIX . 'fgift_gift';
    }
    
    /**
     * 
     * @param int $userId
     * @param int $giftId
     * @return FGIFT_BOL_Gift
     */
    public function setGift( $userId, $giftId )
    {
        $gift = $this->findGift($userId);
        
        if ( $gift === null )
        {
            $gift = new FGIFT_BOL_Gift();
        }
        
        $gift->userId = $userId;
        $gift->giftId = $giftId;
        $gift->timeStamp = time();
        
        $this->save($gift);
        
        return $gift;
    }
    
    /**
     * 
     * @param int $userId
     * @return FGIFT_BOL_Gift
     */
    public function findGift( $userId )
    {
        $example = new OW_Example();
        $example->andFieldEqual("userId", $userId);
        
        return $this->findObjectByExample($example);
    }
    
    public function deleteGift( $userId )
    {
        $example = new OW_Example();
        $example->andFieldEqual("userId", $userId);
        
        $this->deleteByExample($example);
    }
}