<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * @author Sergey Kambalin <greyexpert@gmail.com>
 * @package fgift.classes
 */
class FGIFT_CLASS_Credits
{
    const ACTION_ADD_GIFT = 'add_fgift';

    public $allActions = array();

    private $actions;

    public function __construct()
    {
        $this->actions[] = array('pluginKey' => 'fgift', 'action' => self::ACTION_ADD_GIFT, 'amount' => 0);

        $this->allActions = array(
            self::ACTION_ADD_GIFT
        );
    }

    public function bindCreditActionsCollect( BASE_CLASS_EventCollector $e )
    {
        foreach ( $this->actions as $action )
        {
            $e->add($action);
        }
    }

    public function triggerCreditActionsAdd()
    {
        $e = new BASE_CLASS_EventCollector('usercredits.action_add');

        foreach ( $this->actions as $action )
        {
            $e->add($action);
        }

        OW::getEventManager()->trigger($e);
    }

    public function isAvaliable( $action )
    {
        $eventParams = array(
            'pluginKey' => 'fgift',
            'action' => $action
        );

        $credits = OW::getEventManager()->call('usercredits.check_balance', $eventParams);

        return $credits === null ? true : $credits;
    }

    public function getErrorMessage( $action )
    {
        $eventParams = array(
            'pluginKey' => 'fgift',
            'action' => $action
        );

        return OW::getEventManager()->call('usercredits.error_message', $eventParams);
    }

    public function trackUse( $action )
    {
        $eventParams = array(
            'pluginKey' => 'fgift',
            'action' => $action
        );

        OW::getEventManager()->call('usercredits.track_action', $eventParams);
    }
}