<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * @author Sergey Kambalin <greyexpert@gmail.com>
 * @package fgift.classes
 */
class FGIFT_CLASS_NewsfeedBridge
{
    /**
     * Singleton instance.
     *
     * @var FGIFT_CLASS_NewsfeedBridge
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return FGIFT_CLASS_NewsfeedBridge
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    
    public function isActive()
    {
        return OW::getPluginManager()->isPluginActive("newsfeed");
    }
    
    public function onItemRender( OW_Event $event )
    {
        $params = $event->getParams();
        $data = $event->getData();
        
        if ( $params["action"]["entityType"] != "user_gift" )
        {
            return;
        }
        
        $giftId = $params["action"]["entityId"];
        $data["contextMenu"] = empty($data["contextMenu"]) ? array() : $data["contextMenu"];
        $realGift = FGIFT_CLASS_GiftsBridge::getInstance()->findGiftById($giftId);
        if ( $realGift === null )
        {
            return;
        }
        
        /*@var $giftDto VIRTUALGIFTS_BOL_UserGift */
        $giftDto = $realGift["dto"];
        
        if ( $giftDto->recipientId != OW::getUser()->getId() && !OW::getUser()->isAuthorized("fgift") )
        {
            return;
        }
        
        $uniqId = "fgifts-set-gift-" . $giftDto->id;
        $rsp = OW::getRouter()->urlFor("FGIFT_CTRL_Main", "ajax");
        $text = OW::getLanguage()->text("fgift", "set_gift_label");
        $action = "setGift";

        $fGift = FGIFT_BOL_Service::getInstance()->findGift($giftDto->recipientId);

        if ( $fGift !== null && $fGift->giftId == $giftDto->id )
        {
            $text = OW::getLanguage()->text("fgift", "unset_gift_label");
            $action = "unsetGift";
        } 
        else if ( !OW::getUser()->isAuthorized("fgift", "add_gift") )
        {
            return;
        }

        $data["contextMenu"][] = array(
            'label' => $text,
            'attributes' => array(
                'id' => $uniqId,
                "data-action" => $action,
                "data-text" => $text
            )
        );
        
        $event->setData($data);
        
        $js = UTIL_JsGenerator::composeJsString('(function() { 
            $("#' . $uniqId . '").click(function() {
                var self = $(this);
                window.FGIFT_CC = window.FGIFT_CC || {$available};
                if ( self.attr("data-action") == "setGift" && window.FGIFT_CC && window.FGIFT_CC !== true ) {
                    OW.warning(window.FGIFT_CC);

                    return false;
                }
                
                if ( self.attr("data-action") == "setGift" )
                {
                    if (window.FGIFT_setGift) {
                        window.FGIFT_setGift({$giftSrc}, {$giftUrl});
                    }
                }
                else
                {
                    if (window.FGIFT_unsetGift) {
                        window.FGIFT_unsetGift();
                    }
                }

                $.getJSON({$rsp}, {giftId: {$giftId}, userId: {$userId}, action: self.attr("data-action")}, function(r) { 
                    OW[r.type](r.msg);
                    window.FGIFT_CC = r.avaliable;
                });

                self.attr("data-text", self.attr("data-text") == {$textSet} ? {$textUnset} : {$textSet});
                self.attr("data-action", self.attr("data-action") == "setGift" ? "unsetGift" : "setGift");
                self.text(self.attr("data-text"));
        }); })();', array(
            "rsp" => $rsp,
            "giftId" => $giftDto->id,
            "userId" => $giftDto->recipientId,
            "action" => $action,
            "text" => $text,
            "textSet" => OW::getLanguage()->text("fgift", "set_gift_label"),
            "textUnset" => OW::getLanguage()->text("fgift", "unset_gift_label"),
            "giftSrc" => $realGift["imageUrl"],
            "giftUrl" => $realGift["url"],
            "available" => FGIFT_CLASS_CreditsBridge::getInstance()->getAvailable()
        ));

        OW::getDocument()->addOnloadScript($js);
    }
    
    public function init()
    {
        if ( !$this->isActive() )
        {
            return;
        }
        
        OW::getEventManager()->bind("feed.on_item_render", array($this, 'onItemRender'));
    }
}