<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * @author Sergey Kambalin <greyexpert@gmail.com>
 * @package fgift.controllers
 */
class FGIFT_CTRL_Main extends OW_ActionController
{
    public function ajax()
    {
        $userId = $_GET["userId"];
        $giftId = $_GET["giftId"];
        
        $action = $_GET["action"];
        
        $type = "info";
        $msg = "";
        if ( $action == "setGift" )
        {
            FGIFT_BOL_Service::getInstance()->setGift($userId, $giftId);
            $msg = OW::getLanguage()->text("fgift", "set_gift_message");
            
            FGIFT_CLASS_CreditsBridge::getInstance()->credits->trackUse(FGIFT_CLASS_Credits::ACTION_ADD_GIFT);
        }
        else
        {
            FGIFT_BOL_Service::getInstance()->deleteGift($userId);
            $msg = OW::getLanguage()->text("fgift", "unset_gift_message");
        }
        
        echo json_encode(array(
            "type" => $type,
            "msg" => $msg,
            "avaliable" => FGIFT_CLASS_CreditsBridge::getInstance()->getAvailable()
        ));
        exit;
    }
}