<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

if ( FGIFT_CLASS_GiftsBridge::getInstance()->isActive() )
{
    FGIFT_CLASS_GiftsBridge::getInstance()->init();
    FGIFT_CLASS_NewsfeedBridge::getInstance()->init();
    FGIFT_CLASS_CreditsBridge::getInstance()->init();
}
else
{
    OW::getEventManager()->bind('admin.add_admin_notification', "fgift_collect_admin_notifications");
}



function fgift_get_current_gift( OW_Event $event )
{
    if ( !FGIFT_CLASS_GiftsBridge::getInstance()->isActive() )
    {
        $event->setData(null);
        return null;
    }
    
    $params = $event->getParams();
    $gift = FGIFT_BOL_Service::getInstance()->findGift($params["userId"]);
    
    if ( $gift === null )
    {
        $event->setData(null);
        return null;
    }
    
    if ( $gift->userId != OW::getUser()->getId() && !OW::getUser()->isAuthorized("fgift") && !OW::getUser()->isAuthorized("fgift", "view_gift") )
    {
        $event->setData(null);
        return null;
    }
    
    $realGift = FGIFT_CLASS_GiftsBridge::getInstance()->findGiftById($gift->giftId);
    
    if ( $realGift === null )
    {
        $event->setData(null);
        return null;
    }
    
    $data = array(
        "src" => $realGift["imageUrl"],
        "giftId" => $realGift["dto"]->id,
        "url" => $realGift["url"]
    );
    
    $event->setData($data);
    
    return $data;
}
OW::getEventManager()->bind("fgift.get_user_gift", "fgift_get_current_gift");


function fgift_add_auth_labels( BASE_CLASS_EventCollector $event )
{
    $language = OW::getLanguage();
    $event->add(
        array(
            'fgift' => array(
                'label' => $language->text('fgift', 'auth_group_label'),
                'actions' => array(
                    'view_gift' => $language->text('fgift', 'auth_action_label_view_gift'),
                    'add_gift' => $language->text('fgift', 'auth_action_label_add_gift')
                )
            )
        )
    );
}

OW::getEventManager()->bind('admin.add_auth_labels', 'fgift_add_auth_labels');


function fgift_collect_admin_notifications( BASE_CLASS_EventCollector $e )
{
    $language = OW::getLanguage();
    $e->add($language->text('fgift', 'admin_plugin_required_notification', array(
        'pluginUrl' => 'http://www.oxwall.org/store/item/52'
    )));
}