<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 *
 * @author Sergey Kambalin <greyexpert@gmail.com>
 * @package fgift.bol
 */
class FGIFT_BOL_Service
{
    /**
     * Singleton instance.
     *
     * @var FGIFT_BOL_Service
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return FGIFT_BOL_Service
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    
    /**
     *
     * @var FGIFT_BOL_GiftDao
     */
    private $giftDao;
    
    private function __construct() 
    {
        $this->giftDao = FGIFT_BOL_GiftDao::getInstance();
    }
    
    /**
     * 
     * @param int $userId
     * @param int $giftId
     * @return FGIFT_BOL_Gift
     */
    public function setGift( $userId, $giftId )
    {
        return $this->giftDao->setGift($userId, $giftId);
    }
    
    /**
     * 
     * @param int $userId
     * @return FGIFT_BOL_Gift
     */
    public function findGift( $userId )
    {
        return $this->giftDao->findGift($userId);
    }
    
    public function deleteGift( $userId )
    {
        $this->giftDao->deleteGift($userId);
    }
}
