<?php

/**
 * Copyright (c) 2013, Sergey Kambalin
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * @author Sergey Kambalin <greyexpert@gmail.com>
 * @package fgift.classes
 */
class FGIFT_CLASS_CreditsBridge
{
    /**
     * Singleton instance.
     *
     * @var FGIFT_CLASS_CreditsBridge
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return FGIFT_CLASS_CreditsBridge
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     *
     * @var FGIFT_CLASS_Credits
     */
    public $credits;

    /**
     *
     * @var OW_Plugin
     */
    private $plugin;

    private function __construct()
    {
        $this->credits = new FGIFT_CLASS_Credits();
        $this->plugin = OW::getPluginManager()->getPlugin('fgift');
    }

    public function getAvailable()
    {
        $avaliable = $this->credits->isAvaliable(FGIFT_CLASS_Credits::ACTION_ADD_GIFT);
        if ( !$avaliable )
        {
            $avaliable = $this->credits->getErrorMessage(FGIFT_CLASS_Credits::ACTION_ADD_GIFT);
        }
        
        return $avaliable;
    }

    public function init()
    {
        $this->credits->triggerCreditActionsAdd();
        OW::getEventManager()->bind('usercredits.on_action_collect', array($this->credits, 'bindCreditActionsCollect'));
    }
}