<?php

class GOTOP_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    public function __construct()
    {
        parent::__construct();

        if ( OW::getRequest()->isAjax() )
        {
            return;
        }

        $lang = OW::getLanguage();

        $this->setPageHeading($lang->text('gotop', 'admin_settings_title'));
        $this->setPageTitle($lang->text('gotop', 'admin_settings_title'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    public function settings()
    {
        $adminForm = new Form('adminForm');      

        $lang = OW::getLanguage();
        $config = OW::getConfig();
        

        $element = new TextField('EaseSpeed');
        $element->setRequired(true);
        $validator = new IntValidator(1);
        $validator->setErrorMessage($lang->text('gotop', 'admin_invalid_number_error'));
        $element->addValidator($validator);        
        $element->setLabel($lang->text('gotop', 'admin_style'));
        $element->setValue($config->getValue('gotop', 'EaseSpeed')); 
        $adminForm->addElement($element);
        
        
        $selectField = new Selectbox("Easing");
        $selectField->setLabel($lang->text("gotop", "admin_selectbox_field_label"));
        $selectField->setRequired(true);
        $selectField->setInvitation($lang->text('gotop', 'admin_selectbox_value'));
        $selectField->setValue($config->getValue('gotop', 'Easing'));
        $selectField->setOptions(array(
            "linear" => "linear",
            "swing" => "swing",
            "easeInQuad" => "easeInQuad",
            "easeOutQuad" => "easeOutQuad",
            "easeInOutQuad" => "easeInOutQuad",
            "easeInCubic" => "easeInCubic",
            "easeOutCubic" => "easeOutCubic",
            "easeInOutCubic" => "easeInOutCubic",
            "easeInQuart" => "easeInQuart",
            "easeOutQuart" => "easeOutQuart",
            "easeInOutQuart" => "easeInOutQuart",
            "easeInQuint" => "easeInQuint",
            "easeOutQuint" => "easeOutQuint",
            "easeInOutQuint" => "easeInOutQuint",
            "easeInExpo" => "easeInExpo",
            "easeOutExpo" => "easeOutExpo",
            "easeInOutExpo" => "easeInOutExpo",
            "easeInSine" => "easeInSine",
            "easeOutSine" => "easeOutSine",
            "easeInOutSine" => "easeInOutSine",
            "easeInCirc" => "easeInCirc",
            "easeOutCirc" => "easeOutCirc",
            "easeInOutCirc" => "easeInOutCirc",
            "easeInElastic" => "easeInElastic",
            "easeOutElastic" => "easeOutElastic",
            "easeInOutElastic" => "easeInOutElastic",
            "easeInBack" => "easeInBack",
            "easeOutBack" => "easeOutBack",
            "easeInOutBack" => "easeInOutBack",
            "easeInBounce" => "easeInBounce",
            "easeOutBounce" => "easeOutBounce",
            "easeInOutBounce" => "easeInOutBounce"
            
        ));
        
        $adminForm->addElement($selectField);
        
        
        $element = new TextField('InDelay');
        $element->setRequired(true);
        $validator = new IntValidator(1);
        $validator->setErrorMessage($lang->text('gotop', 'admin_invalid_number_error'));
        $element->addValidator($validator);
        $element->setLabel($lang->text('gotop', 'admin_indelay'));
        $element->setValue($config->getValue('gotop', 'InDelay')); 
        $adminForm->addElement($element);

        $element = new TextField('OutDelay');
        $element->setRequired(true);
        $validator = new IntValidator(1);
        $validator->setErrorMessage($lang->text('gotop', 'admin_invalid_number_error'));
        $element->addValidator($validator);
        $element->setLabel($lang->text('gotop', 'admin_outdelay'));
        $element->setValue($config->getValue('gotop', 'OutDelay')); 
        $adminForm->addElement($element);        
        
        


        $element = new Submit('saveEaseSettings');
        $element->setValue($lang->text('gotop', 'admin_save_settings'));
        $adminForm->addElement($element);

        if ( OW::getRequest()->isPost() )
        {
           if ( $adminForm->isValid($_POST) )
           {
              $values = $adminForm->getValues(); 
              $config = OW::getConfig();
              $config->saveConfig('gotop', 'EaseSpeed', $values['EaseSpeed']);
              $config->saveConfig('gotop', 'Easing', $values['Easing']);
              $config->saveConfig('gotop', 'InDelay', $values['InDelay']);
              $config->saveConfig('gotop', 'OutDelay', $values['OutDelay']);


              OW::getFeedback()->info($lang->text('gotop', 'user_save_success')); 
           }
        }

       $this->addForm($adminForm);
   } 
}
