<?php

/**
 * Copyright (c) 2013, Kairat Bakytow
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * 
 *
 * @author Kairat Bakytow <kainisoft@gmail.com>
 * @package ow_plugins.smileys.bol
 * @since 1.0
 */
class SMILEYS_BOL_Service
{
    private static $classInstance;
    
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    
    private $plugin;

    private function __construct()
    {
        $this->plugin = OW::getPluginManager()->getPlugin( 'smileys' );
    }

    public function getSmilesCategories()
    {
        $categories = scandir( $this->plugin->getUserFilesDir() . 'images' . DS );
        unset( $categories[0] );
        unset( $categories[1] );

        return array_unique( array_map('strtolower', $categories) );
    }
    
    public function getSmileysByCategory( $category )
    {
        $dir = $this->plugin->getUserFilesDir() . 'images' . DS . strtolower( $category );
        
        if ( !empty($category) && file_exists($dir) )
        {
            $smileys = scandir( $dir );
            unset( $smileys[0] );
            unset( $smileys[1] );
            
            return array_unique( array_map('strtolower', $smileys) );
        }
        else
        {
            return array();
        }
    }
    
    public function getThemeList()
    {
        $themes = scandir( $this->plugin->getStaticDir() . 'css' . DS . 'ui' );
        unset( $themes[0] );
        unset( $themes[1] );
        
        return $themes;
    }
}
