<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is
 * licensed under The BSD license.

 * ---
 * Copyright (c) 2013, Oxwall Foundation
 * All rights reserved.

 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 * following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice, this list of conditions and
 *  the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 *  the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *  - Neither the name of the Oxwall Foundation nor the names of its contributors may be used to endorse or promote products
 *  derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @author Podyachev Evgeny <joker.OW2@gmail.com>
 * @since 1.0
 */

class RECAPTCHA_CLASS_RecaptchaField extends FormElement
{
    const CAPTCHA_PREFIX = 'ow_captcha_';


    public $jsObjectName = null;

    /**
     * Constructor.
     *
     * @param string $name
     */
    public function __construct( $name )
    {
        parent::__construct($name);

        $this->value = array(
            'recaptcha_challenge_field' => !empty($_POST['recaptcha_challenge_field']) ? $_POST['recaptcha_challenge_field'] : '',
            'recaptcha_response_field' => !empty($_POST['recaptcha_response_field']) ? $_POST['recaptcha_response_field'] : ''
        );
    }

    public function addValidator( $validator )
    {
        if ( $validator instanceof RECAPTCHA_CLASS_RecaptchaValidator )
        {
            $validator->setJsObjectName($this->getName());
        }

        return parent::addValidator($validator);
    }

    public function setValue( $value )
    {
        $this->value = array(
            'recaptcha_challenge_field' => !empty($_POST['recaptcha_challenge_field']) ? $_POST['recaptcha_challenge_field'] : '',
            'recaptcha_response_field' => !empty($_POST['recaptcha_response_field']) ? $_POST['recaptcha_response_field'] : ''
        );
    }

    /**
     * @see FormElement::renderInput()
     *
     * @param array $params
     * @return string
     */
    public function renderInput( $params = null )
    {
        RECAPTCHA_BOL_Service::getInstance()->drawCaptcha($this->getId(), $this->getName());
        
        $attr = $this->attributes;

        unset($attr['name']);

        return UTIL_HtmlTag::generateTag('div', $attr, true);
    }

    public function setRequired( $value = true )
    {
        if ( $value )
        {
            $this->addValidator(new RECAPTCHA_CLASS_RecaptchaValidator());
        }

        return $this;
    }
}

class RECAPTCHA_CLASS_RecaptchaValidator extends OW_Validator
{

    public function __construct()
    {
        $errorMessage = OW::getLanguage()->text('base', 'form_validator_captcha_error_message');

        if ( empty($errorMessage) )
        {
            $errorMessage = 'Captcha Validator Error!';
        }

        $this->setErrorMessage($errorMessage);
    }

    public function isValid( $value )
    {
        $challenge = !empty($value['recaptcha_challenge_field']) ? $value['recaptcha_challenge_field'] : null;
        $presponse = !empty($value['recaptcha_response_field']) ? $value['recaptcha_response_field'] : null;

        return RECAPTCHA_BOL_Service::getInstance()->checkCaptchaValue($challenge, $presponse);
    }

    public function setJsObjectName( $name )
    {
        if ( !empty($name) )
        {
            $this->jsObjectName = $name;
        }
    }

    public function getJsValidator()
    {
        if ( empty($this->jsObjectName) )
        {
            return "{
                    validate : function( value ){
            },
                    getErrorMessage : function(){ return " . json_encode($this->getError()) . " }
            }";
        }
        else
        {
            return "{

                    validate : function( value )
                    {
                        if( !window." . $this->jsObjectName . ".validateCaptcha() )
                        {
                            throw " . json_encode($this->getError()) . ";
                        }
                    },

                    getErrorMessage : function()
                    {
                        return " . json_encode($this->getError()) . ";
                    }
            }";
        }
    }
}