<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is
 * licensed under The BSD license.

 * ---
 * Copyright (c) 2013, Oxwall Foundation
 * All rights reserved.

 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 * following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice, this list of conditions and
 *  the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 *  the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *  - Neither the name of the Oxwall Foundation nor the names of its contributors may be used to endorse or promote products
 *  derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @author Podyachev Evgeny <joker.OW2@gmail.com>
 * @since 1.0
 */

class RECAPTCHA_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index( $params = array() )
    {
        OW::getDocument()->setHeading(OW::getLanguage()->text('recaptcha', 'admin_heading'));
        OW::getDocument()->setTitle(OW::getLanguage()->text('recaptcha', 'admin_title'));

        $form = new Form('recaptcha_settings');

        $publicKey = new TextField('publicKey');
        $publicKey->setLabel(OW::getLanguage()->text('recaptcha', 'public_key_label'));
        $publicKey->setRequired();

        $publicKeyValue = RECAPTCHA_BOL_Service::getInstance()->getPublicKey();
        $publicKey->setValue($publicKeyValue);

        $form->addElement($publicKey);

        $privateKey = new TextField('privateKey');
        $privateKey->setLabel(OW::getLanguage()->text('recaptcha', 'private_key_label'));
        $privateKey->setRequired();

        $privateKeyValue = RECAPTCHA_BOL_Service::getInstance()->getPrivateKey();
        $privateKey->setValue($privateKeyValue);

        $form->addElement($privateKey);
        
        $options = array(
            'red' => 'red',
            'white' => 'white',
            'blackglass' => 'blackglass',
            'clean' => 'clean'
            );
        
        $theme = new Selectbox('theme');
        $theme->setLabel(OW::getLanguage()->text('recaptcha', 'theme'));
        $theme->setOptions($options);
        $theme->setRequired();

        $value = OW::getConfig()->getValue('recaptcha', 'theme');
        $theme->setValue($value);
        $theme->setHasInvitation(false);

        $form->addElement($theme);

        $apiKeySubmit = new Submit('save_settings');
        $form->addElement($apiKeySubmit);

        $this->addForm($form);

        if ( OW::getRequest()->isPost() )
        {
            $config = OW::getConfig();

            if ( isset($_POST['save_settings']) )
            {
                if ( $form->isValid($_POST) )
                {
                    $data = $form->getValues();
                    $config->saveConfig('recaptcha', 'public_key', $data['publicKey']);
                    $config->saveConfig('recaptcha', 'private_key', $data['privateKey']);
                    $config->saveConfig('recaptcha', 'theme', $data['theme']);

                    OW::getFeedback()->info(OW::getLanguage()->text('recaptcha', 'settings_saved')); //Setting succsessfully saved
                    $this->redirect();
                }
                else
                {
                    OW::getFeedback()->error(OW::getLanguage()->text('recaptcha', 'settings_saved_error')); //
                }
            }
        }

        $this->addForm($form);

        if ( !empty($privateKeyValue) &&  !empty($privateKeyValue) )
        {
            RECAPTCHA_BOL_Service::getInstance()->drawCaptcha('captcha', 'admin_settings_recaptcha');
        }
    }
}
