<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is
 * licensed under The BSD license.

 * ---
 * Copyright (c) 2013, Oxwall Foundation
 * All rights reserved.

 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 * following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice, this list of conditions and
 *  the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 *  the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *  - Neither the name of the Oxwall Foundation nor the names of its contributors may be used to endorse or promote products
 *  derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @author Podyachev Evgeny <joker.OW2@gmail.com>
 * @since 1.0
 */

OW::getRouter()->addRoute(new OW_Route('recaptcha_verify', 'recaptcha/verify', 'RECAPTCHA_CTRL_Verify', 'recaptchaVerify'));
OW::getRouter()->addRoute(new OW_Route('recaptcha_config', 'recaptcha/config', 'RECAPTCHA_CTRL_Admin', 'index'));



function recaptcha_add_members_only_exception( BASE_CLASS_EventCollector $event )
{
    $event->add(array('controller' => 'RECAPTCHA_CTRL_Verify', 'action' => 'recaptchaVerify'));
}
OW::getEventManager()->bind('base.members_only_exceptions', 'recaptcha_add_members_only_exception');

function recaptcha_get_captcha_field( OW_Event $event )
{
    $config = OW::getConfig();
    
    if ( !$config->getValue('recaptcha', 'public_key') || !$config->getValue('recaptcha', 'private_key') )
    {
        return;
    }
    
    $captcha = new RECAPTCHA_CLASS_RecaptchaField('captchaField');
    $captcha->addValidator(new RECAPTCHA_CLASS_RecaptchaValidator());
    $event->setData($captcha);
}
OW::getEventManager()->bind('join.get_captcha_field', 'recaptcha_get_captcha_field');


function recaptcha_on_user_join( OW_Event $event )
{
    foreach ( $_SESSION as $key => $value )
    {
        if ( preg_match('/^'.RECAPTCHA_BOL_Service::RECAPTCHA_SESSION_VAR.'/', $key) )
        {
            OW::getSession()->delete($key);
        }
    }
}
OW::getEventManager()->bind(OW_EventManager::ON_USER_REGISTER, 'recaptcha_on_user_join');

function recaptcha_add_admin_notification( BASE_CLASS_EventCollector $coll )
{
    $config = OW::getConfig();

    if ( $config->getValue('recaptcha', 'public_key') && $config->getValue('recaptcha', 'private_key') )
    {
        return;
    }
        
    OW::getFeedback()->info(OW::getLanguage()->text( 'recaptcha', 'plugin_installation_notice', array('url' => OW::getRouter()->urlForRoute('recaptcha_config') ) ));
    
    $coll->add(
            OW::getLanguage()->text( 'recaptcha', 'plugin_installation_notice', array('url' => OW::getRouter()->urlForRoute('recaptcha_config') ) )
        );
}
OW::getEventManager()->bind('admin.add_admin_notification', 'recaptcha_add_admin_notification');
