<?php

/**
 * Copyright (c) 2014, Kairat Bakytow
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/** 
 * 
 *
 * @author Kairat Bakytow <kainisoft@gmail.com>
 * @package ow_plugins.smileys.classes
 * @since 1.0
 */
class SMILEYS_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    
    private $service;

    private function __construct()
    {
        $this->service = SMILEYS_BOL_Service::getInstance();
    }
    
    public function init()
    {
        OW::getEventManager()->bind(OW_EventManager::ON_FINALIZE, array($this, 'onFinalize'));
        OW::getEventManager()->bind('base.comment_item_process', array($this, 'commentProcess'));
        OW::getEventManager()->bind('feed.on_item_render', array($this, 'onFeedItemRender'), 9999);
        OW::getEventManager()->bind('questions.on_list_item_render', array($this, 'onQuestionRender'));
        OW::getEventManager()->bind('questions.on_question_render', array($this, 'onQuestionRender'));
        
        OW::getEventManager()->bind('event_after_create_event', array($this, 'onEditSave'));
        OW::getEventManager()->bind('event_after_event_edit', array($this, 'onEditSave'));
        
        OW::getEventManager()->bind('groups_group_create_complete', array($this, 'onGroupSave'));
        OW::getEventManager()->bind('groups_group_edit_complete', array($this, 'onGroupSave'));
        
        OW::getEventManager()->bind('video.add_clip', array($this, 'onVideoCreate'), 1000);
        OW::getEventManager()->bind('video.after_edit', array($this, 'onVideoEdit'));
        
        OW::getEventManager()->bind('mailbox.before_create_conversation', array($this, 'onBeforeCreateConversation'));
    }
    
    public function onFinalize( OW_event $event )
    {
        if ( OW::getRequest()->isAjax() )
        {
            return;
        }
        
        $cmp = new SMILEYS_CMP_Panel();
        OW::getDocument()->appendBody($cmp->render());
    }
    
    public function commentProcess( BASE_CLASS_EventProcessCommentItem $event )
    {
        $message = $this->service->replace($event->getDataProp('content'));
        $event->setDataProp('content', $message);
    }
    
    public function onFeedItemRender( OW_Event $event )
    {
        $data = $event->getData();
        
        if ( !empty($data['content']['vars']['status']) )
        {
            $data['content']['vars']['status'] = $this->service->replace($data['content']['vars']['status']);
        }
        elseif ( !empty($data['string']) )
        {
            $data['string'] = $this->service->replace($data['string']);
        }
        
        $event->setData($data);
    }
    
    public function onQuestionRender( OW_Event $event )
    {
        $data = $event->getData();
        
        if ( !empty($data['text']) )
        {
            $data['text'] = $this->service->replace($data['text']);
        }
        
        $event->setData($data);
    }
    
    private function replace( $text )
    {
        return BOL_TextFormatService::getInstance()->processWsForOutput($text, array('buttons' => array(
            BOL_TextFormatService::WS_BTN_BOLD,
            BOL_TextFormatService::WS_BTN_ITALIC,
            BOL_TextFormatService::WS_BTN_UNDERLINE,
            BOL_TextFormatService::WS_BTN_LINK,
            BOL_TextFormatService::WS_BTN_ORDERED_LIST,
            BOL_TextFormatService::WS_BTN_UNORDERED_LIST,
            BOL_TextFormatService::WS_BTN_IMAGE
        )));
    }

    public function onEditSave( OW_Event $event )
    {
        $params = $event->getParams();
        $eventDto = EVENT_BOL_EventDao::getInstance()->findById($params['eventId']);
        
        if ( $eventDto === NULL )
        {
            return;
        }
        
        $eventDto->setDescription($this->replace($_POST['desc']));
        EVENT_BOL_EventDao::getInstance()->save($eventDto);
    }
    
    public function onGroupSave( OW_Event $event )
    {
        $params = $event->getParams();
        $groupDto = GROUPS_BOL_GroupDao::getInstance()->findById($params['groupId']);
        
        if ( $groupDto === NULL )
        {
            return;
        }
        
        $groupDto->description = $this->replace($_POST['description']);
        GROUPS_BOL_GroupDao::getInstance()->save($groupDto);
    }
    
    public function onVideoCreate( OW_Event $event )
    {
        $data = $event->getData();
        
        if ( empty($data['id']) || ($clipDto = VIDEO_BOL_ClipDao::getInstance()->findById($data['id'])) === NULL )
        {
            return;
        }
        
        $clipDto->description = $this->replace($_POST['description']);
        VIDEO_BOL_ClipDao::getInstance()->save($clipDto);
    }
    
    public function onVideoEdit( OW_Event $event )
    {
        $params = $event->getParams();
        
        if ( empty($params['clipId']) || ($clipDto = VIDEO_BOL_ClipDao::getInstance()->findById($params['clipId'])) === NULL )
        {
            return;
        }
        
        $clipDto->description = $this->replace($_POST['description']);
        VIDEO_BOL_ClipDao::getInstance()->save($clipDto);
    }
    
    public function onBeforeCreateConversation( OW_Event $event )
    {
        $data = $event->getData();
        
        if ( empty($data['message']) ) return;
        
        $smileys = $this->service->getSmileysKeyPair();
        $pattern = '/<img src="' . preg_quote($this->service->getSmileysUrl(), '/') . '([^"]+)" \/>/i';
        $message = $this->replace($_POST['message']);
        
        $data['message'] = preg_replace_callback($pattern, function( $match ) use ( $smileys )
        {
            if ( ($key = array_search($match[1], $smileys)) !== FALSE )
            {
                return $key;
            }
            
            return '';
        }, $message);
        
        $event->setData($data);
    }
}
