<?php

/**
 * Copyright (c) 2014, Kairat Bakytow
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 *
 * @author Kairat Bakytow
 * @package ow_plugins.smileys.components
 * @since 1.0
 */
class SMILEYS_CMP_Panel extends OW_Component
{
    public function __construct()
    {
        parent::__construct();
        
        $service = SMILEYS_BOL_Service::getInstance();
        $plugin = OW::getPluginManager()->getPlugin('smileys');
        $document = OW::getDocument();
        
        $document->addStyleSheet($plugin->getStaticCssUrl() . 'smileys.css');

        $document->addScriptDeclarationBeforeIncludes(
            UTIL_JsGenerator::composeJsString(
                ';window.SMILEYSPARAMS = Object.defineProperties({}, {
                    smileysUrl: {value: {$smileysUrl}, enumerable: true},
                    smileys: {value: {$smileys}, enumerable: true}
                });Object.freeze(window.SMILEYSPARAMS);', array(
                    'smileysUrl' => $service->getSmileysUrl(),
                    'smileys' => $service->getSmileysKeyPair()
                )
            )
        );

        $document->addScript($plugin->getStaticJsUrl() . 'smileys.js', 'text/javascript', 9999);
        
        $this->assign('width', (int)OW::getConfig()->getValue('smileys', 'width'));
        $this->assign('url', $service->getSmileysUrl());
        $this->assign('smileys', $service->getAllSmileys());
    }
}
