<?php

/**
 * Copyright (c) 2013, Oxwall CandyStore
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * Affiliate event handler
 *
 * @author Oxwall CandyStore <plugins@oxcandystore.com>
 * @package ow.ow_plugins.ocs_affiliates.classes
 * @since 1.5.3
 */
class OCSAFFILIATES_CLASS_EventHandler
{
    /**
     * Singleton instance.
     *
     * @var OCSAFFILIATES_CLASS_EventHandler
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return OCSAFFILIATES_CLASS_EventHandler
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     *
     * @var OCSAFFILIATES_BOL_Service
     */
    private $service;

    private function __construct()
    {
        $this->service = OCSAFFILIATES_BOL_Service::getInstance();
    }


    public function init()
    {
        $this->genericInit();
    }

    public function genericInit()
    {
        $em = OW::getEventManager();

        $em->bind(OW_EventManager::ON_USER_REGISTER, array($this, 'onUserRegister'));
        $em->bind(OW_EventManager::ON_USER_UNREGISTER, array($this, 'onUserUnregister'));
        $em->bind(OW_EventManager::ON_USER_APPROVE, array($this, 'onUserApprove'));
        $em->bind('base.before_save_user', array($this, 'beforeUserUpdate'));
        $em->bind(OW_EventManager::ON_PLUGINS_INIT, array($this, 'affiliateSystemEntry'));
    }

    public function affiliateSystemEntry()
    {
        if ( defined('OW_CRON') )
        {
            return;
        }

        if ( !OW::getRequest()->isPost() && !OW::getRequest()->isAjax() )
        {
            $this->service->catchAffiliateVisit();
        }
    }

    public function onUserRegister( OW_Event $event )
    {
        $params = $event->getParams();
        $userId = $params['userId'];

        $this->service->catchAffiliateSignup($userId);
    }

    public function onUserUnregister( OW_Event $event )
    {
        $params = $event->getParams();
        $userId = $params['userId'];

        $service = OCSAFFILIATES_BOL_Service::getInstance();
        $service->deleteAffiliateUserByUserId($userId);
    }

    public function onUserApprove( OW_Event $event )
    {
        if ( OW::getConfig()->getValue('ocsaffiliates', 'signup_event') != 'approve' )
        {
            return;
        }

        $params = $event->getParams();
        $userId = $params['userId'];

        $user = BOL_UserService::getInstance()->findUserById($userId);

        if ( !$user )
        {
            return;
        }

        $signup = OCSAFFILIATES_BOL_Service::getInstance()->findAffiliateSignupByUserId($userId);
        if ( !$signup )
        {
            return;
        }

        $signup->active = 1;
        OCSAFFILIATES_BOL_SignupDao::getInstance()->save($signup);
    }

    public function beforeUserUpdate( OW_Event $event )
    {
        if ( OW::getConfig()->getValue('ocsaffiliates', 'signup_event') != 'email_confirm' )
        {
            return;
        }

        $params = $event->getParams();

        $userId = $params['dto']->id;
        $user = BOL_UserService::getInstance()->findUserById($userId);

        if ( !$user || !$params['dto']->emailVerify )
        {
            return;
        }

        $signup = OCSAFFILIATES_BOL_Service::getInstance()->findAffiliateSignupByUserId($userId);
        if ( !$signup )
        {
            return;
        }

        $signup->active = 1;
        OCSAFFILIATES_BOL_SignupDao::getInstance()->save($signup);
    }
}