<?php

/**
 * Copyright (c) 2013, Oxwall CandyStore
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * Affiliate events log component
 * 
 * @author Oxwall CandyStore <plugins@oxcandystore.com>
 * @package ow.ow_plugins.ocs_affiliates.components
 * @since 1.7.0
 */
class OCSAFFILIATES_CMP_AffiliateLog extends OW_Component
{
    public function __construct( $affiliateId, $adminMode = false )
    {
        parent::__construct();

        $service = OCSAFFILIATES_BOL_Service::getInstance();
        $affiliate = $service->findAffiliateById($affiliateId);

        if ( !$affiliate )
        {
            $this->setVisible(false);

            return;
        }

        $limit = 20;
        $page = !empty($_GET['page']) ? abs((int) $_GET['page']) : 1;
        $offset = ($page - 1) * $limit;

        $log = $service->getAffiliateEventsLog($affiliateId, $offset, $limit);
        $this->assign('log', $log);

        $total = $service->countAffiliateEventsLog($affiliateId);

        // Paging
        $pages = (int) ceil($total / $limit);
        $paging = new BASE_CMP_Paging($page, $pages, $limit);
        $this->assign('paging', $paging->render());

        $billingService = BOL_BillingService::getInstance();
        $this->assign('currency', $billingService->getActiveCurrency());

        $this->assign('adminMode', $adminMode);

        if ( $adminMode )
        {
            $script = '$(".delete_log_event").click(function(){
                if ( confirm('.json_encode(OW::getLanguage()->text('base', 'are_you_sure')).') )
                {
                    $.ajax({
                        url: '.json_encode(OW::getRouter()->urlForRoute('ocsaffiliates.action_delete_log_event')).',
                        type: "POST",
                        data: { affiliateId: ' . $affiliateId . ', eventId : $(this).data("eid"), eventType : $(this).data("etype") },
                        dataType: "json",
                        success: function(data) {
                            if ( data.result == true ) {
                                document.location.reload();
                            }
                        }
                    });
                }
            });
            ';

            OW::getDocument()->addOnloadScript($script);
        }
    }
}