<?php

/**
 * Copyright (c) 2013, Oxwall CandyStore
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * Affiliate register payout component
 * 
 * @author Oxwall CandyStore <plugins@oxcandystore.com>
 * @package ow.ow_plugins.ocs_affiliates.components
 * @since 1.5.3
 */
class OCSAFFILIATES_CMP_RegisterPayout extends OW_Component
{
    public function __construct( $affiliateId )
    {
        parent::__construct();

        $service = OCSAFFILIATES_BOL_Service::getInstance();

        $clicksSum = $service->getClicksSumForAffiliate($affiliateId);
        $signupSum = $service->getRegistrationsSumForAffiliate($affiliateId);
        $salesSum = $service->getSalesSumForAffiliate($affiliateId);
        $earnings = $clicksSum + $signupSum + $salesSum;
        $payouts = $service->getPayoutSum($affiliateId);
        $balance = intval($earnings - $payouts);

        if ( !$balance )
        {
            $balance = 1;
        }

        $form = new OCSAFFILIATES_CLASS_RegisterPayoutForm('register_payout', $affiliateId);
        $form->getElement('affiliateId')->setValue($affiliateId);
        $form->getElement('amount')->setValue($balance);

        $assoc = OCSAFFILIATES_BOL_Service::getInstance()->getAffiliateAssocUser($affiliateId);
        $this->assign('assocUser', $assoc);

        $creditsOption = OW::getPluginManager()->isPluginActive('usercredits') && $assoc;
        $this->assign('creditsOption', $creditsOption);

        if ( $creditsOption )
        {
            $rate = OW::getConfig()->getValue('ocsaffiliates', 'credits_rate');

            $script =
            '$("input[name=byCredits]").change(function(){
                $("#payout-credits-info").css("display", $(this).prop("checked") ? "block" : "none");
            });

            $("input[name=amount]").keyup(function(){
                var amount = '.$rate.' * parseInt($(this).val());
                $("#payout-credits-amount").html( amount > 0 ? amount : "0" );
            });
            ';

            OW::getDocument()->addOnloadScript($script);

            $rate = OW::getConfig()->getValue('ocsaffiliates', 'credits_rate');
            $this->assign('defaultCreditsAmount', $balance * $rate);
        }

        $billingService = BOL_BillingService::getInstance();
        $this->assign('currency', $billingService->getActiveCurrency());

        $this->addForm($form);
    }
}