<?php

/**
 * Copyright (c) 2013, Oxwall CandyStore
 * All rights reserved.

 * ATTENTION: This commercial software is intended for use with Oxwall Free Community Software http://www.oxwall.org/
 * and is licensed under Oxwall Store Commercial License.
 * Full text of this license can be found at http://www.oxwall.org/store/oscl
 */

/**
 * Affiliate cron job
 *
 * @author Oxwall CandyStore <plugins@oxcandystore.com>
 * @package ow.ow_plugins.ocs_affiliates
 * @since 1.5.3
 */
class OCSAFFILIATES_Cron extends OW_Cron
{
    /**
     *
     * @var OCSAFFILIATES_BOL_Service
     */
    private $service;

    public function __construct()
    {
        parent::__construct();

        $this->addJob('checkSales', 5);
        $this->addJob('expireResetPasswords', 60);
        //$this->addJob('doAutoPayouts', 1);

        $this->service = OCSAFFILIATES_BOL_Service::getInstance();
    }


    public function run() { }


    public function checkSales()
    {
        $sales = $this->service->getUntrackedSales(10);

        if ( !$sales )
        {
            return;
        }

        foreach ( $sales as $sale )
        {
            $this->service->trackSale($sale->userId, $sale->id, $sale->totalAmount);
        }

        return;
    }

    /*public function doAutoPayouts()
    {
        $list = OCSAFFILIATES_BOL_Service::getInstance()->getListForAutoPayout();

        if ( !$list )
        {
            return true;
        }

        foreach ( $list as $affiliate )
        {
            $forPayout = $affiliate['balance'];

            $payout = new OCSAFFILIATES_BOL_Payout();
            $payout->affiliateId = $affiliate['id'];
            $payout->amount = abs(floatval($forPayout));
            $payout->paymentDate = time();
            $payout->method = 'credits';

            $assoc = OCSAFFILIATES_BOL_Service::getInstance()->getAffiliateAssocUser($affiliate['id']);
            if ( OW::getPluginManager()->isPluginActive('usercredits') && $assoc )
            {
                USERCREDITS_BOL_CreditsService::getInstance()->increaseBalance($assoc['id'], $payout->amount * 1000);

                OCSAFFILIATES_BOL_Service::getInstance()->registerPayout($payout);
            }
        }

        return true;
    }*/


    public function expireResetPasswords()
    {
        $this->service->deleteExpiredResetPasswordCodes();
    }
}