<?php


class EMAIL2FUTURE_BOL_FriendsDao extends OW_BaseDao
{


    protected function __construct()
    {
        parent::__construct();
    }

    private static $classInstance;


    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    public function getDtoClassName()
    {
        return 'FRIENDS_BOL_Friends';
    }

    public function getTableName()
    {
        return OW_DB_PREFIX . 'friends_friendship';
    }
    
    
    public function count( $userId, $userIdList = null )
    {
        $queryParts1 = BOL_UserDao::getInstance()->getUserQueryFilter("friends_friendship", "userId", array(
            "method" => "FRIENDS_BOL_FriendshipDao::findFriendIdList1"
        ));

        $queryParts2 = BOL_UserDao::getInstance()->getUserQueryFilter("friends_friendship", "friendId", array(
            "method" => "FRIENDS_BOL_FriendshipDao::findFriendIdList2"
        ));

        $query = "SELECT SUM(`count`) AS `count` FROM (
            ( SELECT COUNT(*) AS `count` FROM `" . $this->getTableName() . "` AS `friends_friendship`
            ".$queryParts1['join']."
            WHERE ".$queryParts1['where']." AND `friends_friendship`.`status` = :status1 AND `friends_friendship`.`friendId` = :userId1
            " . ( empty($userIdList) ? '' : " AND `userId` IN ( " . $this->dbo->mergeInClause($userIdList) . " )" ) . " )
            UNION ALL
            ( SELECT COUNT(*) AS `count` FROM `" . $this->getTableName() . "` AS `friends_friendship`
            ".$queryParts2['join']."
            WHERE ".$queryParts2['where']." AND `friends_friendship`.`status` = :status2 AND `friends_friendship`.`userId` = :userId2
            " . ( empty($userIdList) ? '' : " AND `friendId` IN ( " . $this->dbo->mergeInClause($userIdList) . " )" ) . " )
            ) AS `temp`";

        $cacheLifeTime = 86400;
        $tags = array( 'friends.count' );

        return (int)$this->dbo->queryForColumn($query,
            array('userId1' => $userId,
                'userId2' => $userId,
                    'status1' => 'active',
                    'status2' => 'active'
                ),
            $cacheLifeTime,
            $tags
        );
    }
    
    
    public function get_friends($userId, $first, $count, $userIdList = null)
    {
        $queryParts1 = BOL_UserDao::getInstance()->getUserQueryFilter("friends_friendship", "userId", array(
            "method" => "FRIENDS_BOL_FriendshipDao::findFriendIdList1"));

        $queryParts2 = BOL_UserDao::getInstance()->getUserQueryFilter("friends_friendship", "friendId", array(
            "method" => "FRIENDS_BOL_FriendshipDao::findFriendIdList2"));

        $query = "( SELECT `friends_friendship`.`userId` FROM `" . $this->getTableName() . "` AS `friends_friendship`
            ".$queryParts1['join']."
            WHERE ".$queryParts1['where']." AND `friends_friendship`.`status` = :status1 AND `friends_friendship`.`friendId` = :userId1
            " . ( empty($userIdList) ? '' : " AND `friends_friendship`.`userId` IN ( " . $this->dbo->mergeInClause($userIdList) . " )" ) . " )
            UNION
            ( SELECT `friends_friendship`.`friendId` AS `userId` FROM `" . $this->getTableName() . "` AS `friends_friendship`
            ".$queryParts2['join']."
            WHERE ".$queryParts2['where']." AND `friends_friendship`.`status` = :status2 AND `friends_friendship`.`userId` = :userId2
            " . ( empty($userIdList) ? '' : " AND `friends_friendship`.`friendId` IN ( " . $this->dbo->mergeInClause($userIdList) . " )" ) . " )
            LIMIT :first, :count
            ";

        $cacheLifeTime = 86400;
        $tags = array( 'friends.friend_id_list' );

        return $this->dbo->queryForColumnList($query,
            array(
                'userId1' => $userId,
                'userId2' => $userId,
                'status1' => 'active',
                'status2' => 'active',
                'first' => $first,
                'count' => $count),
            $cacheLifeTime,
            $tags
        );
    }

}
