<?php


class EMAIL2FUTURE_BOL_Service
{
 
    private static $classInstance;
    private $recordDao;
    private $friends;
    
    private function __construct()
    {
        $this->recordDao = EMAIL2FUTURE_BOL_RecordDao::getInstance();
        $this->friends = EMAIL2FUTURE_BOL_FriendsDao::getInstance();
    }
    
    static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    function add_letter( $uid, $email, $subject, $content, $timestamp )
    {
        $record = new EMAIL2FUTURE_BOL_Record;
        $record->email = $email;
        $record->sender_id = $uid;
        $record->subject = $subject;
        $record->content = $content;
        $record->timestamp = $timestamp;
        $record->state = 1;
        
        return $this->recordDao->save($record);
    }
    
    function friends_count($uid)
    {
        return $this->friends->count($uid, NULL);
    }
    
    function get_friends($uid)
    {
        return $this->friends->get_friends($uid, 0, $this->friends_count($uid), NULL);
    }
    
    function count($identity, $value)
    {
        $example = new OW_Example();
        $example->andFieldEqual($identity, $value);
        return $this->recordDao->countByExample($example);
    }
    
    function most_sent_out_users()
    {
        return $this->recordDao->most_sent_out_users();
    }
    
    function handler()
   {
      $now = time();
      $site_email = OW::getConfig()->getValue('base', 'site_email');
      $site_name = OW::getConfig()->getValue('base', 'site_name');
      $data = $this->get_letters($now);
      if (!is_array($data) || empty($data)) {
          return FALSE;
      }
      foreach($data as $info) {
          if ($info->state == 1) {
              $this->send_mail($info->subject, $info->content, $info->email, $site_email, $site_name);
              $this->update_state($info->id);
          }
      }
      return TRUE;

   }
 

   public function update_state($id)
    {
        return $this->recordDao->update_state($id);
    }
   
   public function get_letters($value)
   {//get Info of Mail which set For today
      $field = "timestamp";
      $example = new OW_Example();
      $example->andFieldBetween($field, $value-86402, $value);
      return $this->recordDao->findListByExample($example);
   }
   
   
   public function send_mail($subject, $content, $user_email, $site_email, $site_name)
    {
       $html_content = nl2br($content);
       
       $mail = OW::getMailer()->createMail();
       $mail->addRecipientEmail($user_email);
       $mail->setSender($site_email, $site_name);
       $mail->setSubject($subject);
       $mail->setHtmlContent($html_content);
       $mail->setTextContent($content);
       
       OW::getMailer()->addToQueue($mail);
       
       exit();
    }

   
   
   


}

    
