<?php 

class EMAIL2FUTURE_CTRL_Admin extends ADMIN_CTRL_Abstract {
    
    function __construct()
    {
        parent::__construct();
        
        $this->service = EMAIL2FUTURE_BOL_Service::getInstance();
    }
    function settings()
    {
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
        $this->setPageHeading(OW::getLanguage()->text('email2future', 'admin_settings_title'));
        $this->setPageTitle(OW::getLanguage()->text('email2future', 'admin_settings_title'));
        /*
         * Add validators here
         */
        $cron_validator = new IntValidator(60, 86400);
        $cron_validator->setErrorMessage(OW::getLanguage()->text('email2future', 'admin_invalid_number_error'));
        
        $limit_validator = new IntValidator(0);
        $limit_validator->setErrorMessage(OW::getLanguage()->text('email2future', 'admin_user_limit_error'));
        /*
         * Add all inputs and textareas here
         */
        $set_cron_input = new TextField('setcron');
        $set_cron_input->setRequired(TRUE);
        $set_cron_input->addValidator($cron_validator);
        $set_cron_input->setDescription(OW::getLanguage()->text('email2future', "admin_desc_cron"));
        $set_cron_input->setLabel(OW::getLanguage()->text('email2future', "admin_label_cron"));
        $set_cron_input->setValue(OW::getConfig()->getValue('email2future', 'cron'));
        
        $send_perm_input = new Selectbox('send_perm');
        $send_perm_options = array(
            OW::getLanguage()->text('email2future', "admin_perm_themselves"),
            OW::getLanguage()->text('email2future', "admin_perm_friends")
        );
        $send_perm_input->addOptions($send_perm_options);
        $send_perm_input->setRequired(TRUE);
        $send_perm_input->setDescription(OW::getLanguage()->text('email2future', "admin_desc_send_perm"));
        $send_perm_input->setLabel(OW::getLanguage()->text('email2future', "admin_label_send_perm"));
        $send_perm_input->setValue(OW::getConfig()->getValue('email2future', 'send_perm'));
        
        $allow_img_input = new Selectbox('up_img_perm');
        $allow_img_options = array(
            OW::getLanguage()->text('email2future', "admin_perm_img_up_no"),
            OW::getLanguage()->text('email2future', "admin_perm_img_up_yes")
        );
        $allow_img_input->addOptions($allow_img_options);
        $allow_img_input->setRequired(TRUE);
        $allow_img_input->setDescription(OW::getLanguage()->text('email2future', "admin_desc_perm_img_up"));
        $allow_img_input->setLabel(OW::getLanguage()->text('email2future', "admin_label_perm_img_up"));
        $allow_img_input->setValue(OW::getConfig()->getValue('email2future', 'perm_img_up'));
        
        $spam_user_input = new Textarea('spamuser');
        $spam_user_input->addAttribute('placeholder', OW::getLanguage()->text('email2future', "admin_placeholder_unallowed_user"));
        $spam_user_input->setRequired(FALSE);
        $spam_user_input->setDescription(OW::getLanguage()->text('email2future', "admin_desc_unallowed_user"));
        $spam_user_input->setLabel(OW::getLanguage()->text('email2future', "admin_label_unallowed_user"));
        $spam_user_input->setValue($this->username_decode(OW::getConfig()->getValue('email2future', 'spamuser')));
        
        $limit_user_input = new TextField('limit_user');
        $limit_user_input->setRequired(FALSE);
        $limit_user_input->addValidator($limit_validator);
        $limit_user_input->setDescription(OW::getLanguage()->text('email2future', "admin_desc_limit"));
        $limit_user_input->setLabel(OW::getLanguage()->text('email2future', "admin_label_limit"));
        $limit_user_input->setValue(OW::getConfig()->getValue('email2future', 'limit_user'));
        
        $submit_input = new Submit('savecron');
        $submit_input->setValue(OW::getLanguage()->text('email2future', 'admin_save_settings'));
        
        #Create form here
        $admin_form = new Form('adminemailform');
        $admin_form->addElement($set_cron_input);
        $admin_form->addElement($send_perm_input);
        $admin_form->addElement($allow_img_input);
        $admin_form->addElement($spam_user_input);
        $admin_form->addElement($limit_user_input);
        $admin_form->addElement($submit_input);
        
        $this->addForm($admin_form);

        $this->assign('url', OW::getRouter()->getBaseUrl());
        
        $data = $this->service->most_sent_out_users();
        if (!empty($data)) {
            $this->assign('data', $data);
        }
        
        if (OW::getRequest()->isPost()) { # if form is submitted
            if ($admin_form->isValid($_POST)) {
                $this->process_form($admin_form);
            }
        }
    }
    
    
    private function process_form(Form &$form)
    {
        $values = $form->getValues();
        OW::getConfig()->saveConfig('email2future', 'cron', $values['setcron']);
        OW::getConfig()->saveConfig('email2future', 'perm_img_up', $values['up_img_perm']);
        OW::getConfig()->saveConfig('email2future', 'send_perm', $values['send_perm']);
        OW::getConfig()->saveConfig('email2future', 'spamuser', $this->username_encode($values['spamuser']));
        OW::getConfig()->saveConfig('email2future', 'limit_user', $values['limit_user']);
        OW::getFeedback()->info(OW::getLanguage()->text('email2future', 'cron_save_success')); 
    }
    
    private function username_encode($usernames)
    {
        $array_of_username = explode("\n", $usernames);
        if (count($array_of_username) == 1 && trim($array_of_username[0]) == '') {
            $array_of_username = array();
        }
        return json_encode($array_of_username);
    }
    
    private function username_decode($usernames)
    {
        $data = json_decode($usernames);
        if (!count($data) or !is_array($data)) {
			return '';
		}
        return join("\n", $data);
    }

}
