<?php

class EMAIL2FUTURE_CTRL_Future extends OW_ActionController {
    
    private $uid;
    private $service;
    
    function __construct()
    {
        parent::__construct();
        
        $this->uid = OW::getUser()->getId();
        $this->service = EMAIL2FUTURE_BOL_Service::getInstance();
    }
    function index()
    {
        if (!$this->uid) { #Oops
            throw new AuthenticateException();
        }
        
        $this->setPageTitle(OW::getLanguage()->text('email2future', 'index_page_title'));
        $this->setPageHeading(OW::getLanguage()->text('email2future', 'index_page_heading'));

        # add current user to usernames array
        $usernames = array(OW::getUser()->getUserObject()->username=>OW::getLanguage()->text('email2future', 'me_word'));
        $send_to_others = OW::getConfig()->getValue('email2future', 'send_perm');
        if ((int) $send_to_others) {
            $friends_ids = $this->service->get_friends($this->uid);
            #add friends username and id to usernames array
            foreach($friends_ids as $friends_id) {
                $friend_username = BOL_UserService::getInstance()->getUserName($friends_id);
                $display_name = BOL_UserService::getInstance()->getDisplayName($friends_id);
                $usernames[$friend_username] = $display_name;
            }
        }
        #check if user can send letters
        reset($usernames);
        list($no_error, $error_message) = $this->check_can_send_letter(key($usernames));
        
        
        #check if user can send img
        $no_error_img = $this->check_can_send_img();
        
        $today = date('d M Y');
        $current_year = date('Y');
        
        $pending_letters = $this->service->count('state', 1);
        $sent_letters = $this->service->count('state', 0);
        $all_letters = $pending_letters + $sent_letters;
        
        $this->assign('pending_letters', $pending_letters);
        $this->assign('sent_letters', $sent_letters);
        $this->assign('all_letters', $all_letters);
        $this->assign('no_error_img', $no_error_img);
        
        $subject_input = new TextField('subject');
        $subject_input->setLabel(OW::getLanguage()->text('email2future', 'form_label_subject'));
        $subject_input->setdescription(OW::getLanguage()->text('email2future', 'form_desc_subject'));
        $subject_input->addAttribute('value', OW::getLanguage()->text('email2future', 'form_value_subject') . ' '. $today);
        $subject_input->addAttribute('style', "width: 300px");
        $subject_input->setRequired();
        
        $message_input = new Textarea('message');
        $message_input->setLabel(OW::getLanguage()->text('email2future', 'form_label_message'));
        $message_input->setdescription(OW::getLanguage()->text('email2future', 'form_desc_message'));
        $message_input->addAttribute('value', OW::getLanguage()->text('email2future', 'form_value_message'));
        $message_input->setRequired(TRUE);
        
        $receiver_input = new Selectbox("usernames");
        $receiver_input->setLabel(OW::getLanguage()->text("email2future", "selectbox_field_label"));
        $receiver_input->setdescription(OW::getLanguage()->text('email2future', 'form_desc_usernames'));
        $receiver_input->setRequired(TRUE);
        $receiver_input->setInvitation(OW::getLanguage()->text('email2future', 'selectbox_value'));
        $receiver_input->setOptions($usernames);
        
        $start_date_input = new DateField('email_date');
        $start_date_input->setMinYear($current_year);
        $start_date_input->setLabel(OW::getLanguage()->text('email2future', 'form_label_date'));
        $start_date_input->setdescription(OW::getLanguage()->text('email2future', 'form_desc_date'));
        $start_date_input->setMaxYear($current_year + 20);
        $start_date_input->setRequired(TRUE);
        
        $image_input = new FileField('image');
        $image_input->setLabel(OW::getLanguage()->text('email2future', 'upload_image'));
        $image_input->setdescription(OW::getLanguage()->text('email2future', 'form_desc_upload_image'));
        
        $unknown_input = new Selectbox('unknown');
        $unknown_input->setLabel(OW::getLanguage()->text('email2future', 'form_unknown_label'));
        $unknown_input->setdescription(OW::getLanguage()->text('email2future', 'form_unknown_desc'));
        $unknown_input->setRequired(TRUE);
        $unknown_input->setOptions(array(
            OW::getLanguage()->text('email2future', 'admin_perm_img_up_yes'),
            OW::getLanguage()->text('email2future', 'admin_perm_img_up_no')
        ));
        
        $submit_input = new Submit('send');
        $submit_input->setValue(OW::getLanguage()->text('email2future', 'form_label_submit'));
        if(!$no_error) {
            $submit_input->addAttribute('disabled', '""');
        }
        $submit_input->setdescription(OW::getLanguage()->text('email2future', 'form_desc_submit'));
        
        $form = new Form('future_form');
        $form->setEnctype(Form::ENCTYPE_MULTYPART_FORMDATA);
        $form->addElement($subject_input);
        $form->addElement($message_input);
        $form->addElement($receiver_input);
        $form->addElement($start_date_input);
        $form->addElement($image_input);
        $form->addElement($unknown_input);
        $form->addElement($submit_input);
        
        $this->addForm($form);
        if ($no_error) {
            if (OW::getRequest()->isPost()) {
                if ($form->isValid($_POST)) {
                    $this->process_form($form, $no_error_img);
                } else {
                    $form->reset();
                }
            }
        } else {
            OW::getFeedback()->error($error_message);
        }
    }
    
    private function process_form(Form & $form, $img)
    {
        $data = $form->getValues();
        $receiver = BOL_UserService::getInstance()->findByUsername($data['usernames']);
        if ($receiver === NULL) {
            OW::getFeedback()->error(OW::getLanguage()->text('base', 'user_not_found'));
            $form->reset();
            $this->redirect();
            exit();
        }
        $date_parts = explode('/', $data['email_date']);
        $timestamp = mktime(0, 0, 0, $date_parts[1], $date_parts[2], $date_parts[0]);
        if (time() > $timestamp) {
            OW::getFeedback()->error(OW::getLanguage()->text('email2future', 'form_date_error'));
            $this->redirect();
            exit();
        }
        $content = '<p>' . $data['message'] . '<br>';
        if ($img) {
            $img = $this->process_image();
            if ($img !== FALSE) {
                $content .= OW::getLanguage()->text('email2future', 'your_image') . $img . '<br>';
            }
        }
        if ((int) $data['unknown']) {
            $content .= OW::getLanguage()->text('email2future', 'letter_from') . BOL_UserService::getInstance()->getDisplayName($this->uid) . '<br>';
        }

        $content .= OW::getConfig()->getValue('base', 'site_name') . '<p>';
        
        $this->service->add_letter($this->uid, $receiver->email, $data['subject'], $content, $timestamp);
        OW::getFeedback()->info(OW::getLanguage()->text('email2future', 'message_sent'));
        
        $this->redirect();
        exit();
    }

    private function process_image()
    {
        $files = $_FILES;
        $valid = TRUE;
        if ($files['image']['error'] != 0 || 
        !is_uploaded_file($files['image']['tmp_name']) || 
         UTIL_File::validateImage($files['image']['tmp_name'])) {
            $valid = FALSE;
        }
        if (!$valid) {
            OW::getFeedback()->error(OW::getLanguage()->text('base', 'not_valid_image'));
            return FALSE;
        }
        
        $mime = '.'.substr($_FILES['image']['type'], 6); 
        $images_dir = OW::getPluginManager()->getPlugin('email2future')->getUserFilesDir();
        $image_name = 'email2future_'.time() . uniqid().$mime;
        $image_path = $images_dir . $image_name;
        
        $pluginfiles_dir = Ow::getPluginManager()->getPlugin('email2future')->getPluginFilesDir();
        $tmp_image_path = $pluginfiles_dir . 'email2future_' .uniqid() . $mime;
        
        $image = new UTIL_Image($_FILES['image']['tmp_name']);
        $image->saveImage($tmp_image_path);
        
        OW::getStorage()->copyFile($tmp_image_path, $image_path);
        unlink($tmp_image_path);
        return OW::getPluginManager()->getPlugin('email2future')->getUserFilesUrl() . $image_name;
    }
    
    private function check_can_send_letter($current_user_username)
    {
        $max_allow = OW::getConfig()->getValue('email2future', 'limit_user');
        $already_sent_letter = $this->service->count('sender_id', $this->uid);
        if ($already_sent_letter >= $max_allow && $max_allow != 0) {
            return array(FALSE, OW::getLanguage()->text('email2future', 'form_max_allow_error'));
        }
        $restricted_list = json_decode(OW::getConfig()->getValue('email2future', 'spamuser'));
        if (in_array($current_user_username, $restricted_list)) {
            return array(FALSE, OW::getLanguage()->text('email2future', 'form_spam_error'));
        }
        return array(TRUE, '');
    }
    
    private function check_can_send_img()
    {
        $value = OW::getConfig()->getValue('email2future', 'perm_img_up');
        if ($value) {
            return TRUE;
        }
        return FALSE;
    }
}
