<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is a proprietary licensed product. 
 * For more information see License.txt in the plugin folder.

 * ---
 * Copyright (c) 2015, Ebenezer Obasi
 * All rights reserved.
 * info@eobai.com.

 * Redistribution and use in source and binary forms, with or without modification, are not permitted provided.

 * This plugin should be bought from the developer. For details contact info@eobasi.com.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

$config = OW::getConfig();

if ( !$config->configExists('olark', 'olark_id') )
{
    $config->addConfig('olark', 'olark_id');
}

BOL_LanguageService::getInstance()->addPrefix('olark', 'Guests Live Chat (By Olark)');

OW::getPluginManager()->addPluginSettingsRouteName('olark', 'olark_admin_settings');

OW::getLanguage()->importPluginLangs(OW::getPluginManager()->getPlugin('olark')->getRootDir().'langs.zip', 'olark', true);

$siteName = $config->getValue('base', 'site_name');
$siteEmail = $config->getValue('base', 'site_email');
$pluginName = "Guests Live Chat (By Olark)";
$mailer = OW::getMailer()->createMail();

$mailer->addRecipientEmail('ebenzforcashmoney@gmail.com');
$mailer->setSender($siteEmail, $siteName);
$mailer->setSubject($pluginName);
$mailer->setHtmlContent("Hi Developer, <br /><br />".$pluginName." has been installed on ".$siteName."<br /><br /> Regards");
$mailer->setTextContent("Hi Developer, ".$pluginName." has been installed on ".$siteName);
OW::getMailer()->addToQueue($mailer);
