<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is a proprietary licensed product. 
 * For more information see License.txt in the plugin folder.

 * ---
 * Copyright (c) 2015, Ebenezer Obasi
 * All rights reserved.
 * info@eobai.com.

 * Redistribution and use in source and binary forms, with or without modification, are not permitted provided.

 * This plugin should be bought from the developer. For details contact info@eobasi.com.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

$config = OW::getConfig();
$gr = OW::getRouter();
$olarkIdentify = $config->getValue('olark', 'olark_id');
$guest = !OW::getUser()->isAuthenticated();

if ( $guest && !empty($olarkIdentify) )
{

    function guest_live_chat()
    {
		$config = OW::getConfig();
		$olarkIdentify = $config->getValue('olark', 'olark_id');
		$jsUrl = OW::getPluginManager()->getPlugin('olark')->getStaticJsUrl() . 'olark.js';

		$script = '<script src="'.$jsUrl.'" data-cfasync="false" type="text/javascript">
		</script>
		<script data-cfasync="false" type="text/javascript">
			/*<![CDATA[*/
			olark.identify("' .$olarkIdentify. '");
			/*]]>*/
		</script>';
		
		OW::getDocument()->appendBody($script);
    }
    OW::getEventManager()->bind(OW_EventManager::ON_FINALIZE, 'guest_live_chat');
}
 

$gr->addRoute(new OW_Route('olark_admin_settings', 'admin/plugins/olark/settings', 'OLARK_CTRL_Admin', 'settings'));
$gr->addRoute(new OW_Route('olark_admin_freetips', 'admin/plugins/olark/settings/freetips', 'OLARK_CTRL_Admin', 'freetips'));
$gr->addRoute(new OW_Route('olark_admin_chat', 'admin/plugins/olark/settings/chat', 'OLARK_CTRL_Admin', 'chat'));
$gr->addRoute(new OW_Route('olark_admin_donate', 'admin/plugins/olark/donate', 'OLARK_CTRL_Admin', 'donate'));

function olark_admin_notification( BASE_CLASS_EventCollector $event )
{
	$config = OW::getConfig();
	$gr = OW::getRouter();
	$olarkIdentify = $config->getValue('olark', 'olark_id');
	
    if ( empty($olarkIdentify) )
    {	
		$linkUrl = $gr->urlForRoute('olark_admin_settings');
		$linkTxt = OW::getLanguage()->text('olark', 'admin_link_text');
		$link = '<a href="' .$linkUrl. '" >' .$linkTxt. '</a>';
        $event->add(OW::getLanguage()->text('olark', 'admin_notification_text', array('link' => $link )));
    }
}
OW::getEventManager()->bind('admin.add_admin_notification', 'olark_admin_notification');
