<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is a proprietary licensed product. 
 * For more information see License.txt in the plugin folder.

 * ---
 * Copyright (c) 2015, Ebenezer Obasi
 * All rights reserved.
 * info@eobai.com.

 * Redistribution and use in source and binary forms, with or without modification, are not permitted provided.

 * This plugin should be bought from the developer. For details contact info@eobasi.com.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

class TBIRD_CTRL_Admin extends ADMIN_CTRL_Abstract
{
	public function __construct() {
	parent::__construct();

		if (OW::getRequest()->isAjax()) {
			return;
		}

		$lang = OW::getLanguage();

		$menu = new BASE_CMP_ContentMenu();

		$menuItem = new BASE_MenuItem();
		$menuItem->setKey('settings');
		$menuItem->setLabel($lang->text('tbird', 'tbird_admin_settings'));
		$menuItem->setUrl(OW::getRouter()->urlForRoute('tbird_admin_settings'));
		$menuItem->setIconClass('ow_ic_gear_wheel');
		$menuItem->setOrder(1);
		$menu->addElement($menuItem);

		$menuItem = new BASE_MenuItem();
		$menuItem->setKey('freetips');
		$menuItem->setLabel($lang->text('tbird', 'tbird_admin_freetips'));
		$menuItem->setUrl(OW::getRouter()->urlForRoute('tbird_admin_freetips'));
		$menuItem->setIconClass('ow_ic_link');
		$menuItem->setOrder(2);
		$menu->addElement($menuItem);

		$menuItem = new BASE_MenuItem();
		$menuItem->setKey('donate');
		$menuItem->setLabel($lang->text('tbird', 'tbird_admin_donate'));
		$menuItem->setUrl(OW::getRouter()->urlForRoute('tbird_admin_donate'));
		$menuItem->setIconClass('ow_ic_chat');
		$menuItem->setOrder(3);
		$menu->addElement($menuItem);

		$this->addComponent('menu', $menu);
		$this->menu = $menu;
		
	}

    public function settings()
    {
        $this->setPageHeading(OW::getLanguage()->text('tbird', 'admin_settings_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');

        $form = new Form('tbird_settings');
		
		$config = OW::getConfig();		
		$lang = OW::getLanguage();
		
		$fieldTwitterId = new TextField('twitter_id');
        $fieldTwitterId->setLabel($lang->text("tbird", "twitter_id_label"));
        $fieldTwitterId->setHasInvitation(true);
        $fieldTwitterId->setInvitation($lang->text('tbird', 'twitter_id_example'));
        $fieldTwitterId->setDescription($lang->text('tbird', 'twitter_id_desc'));
		$form->addElement($fieldTwitterId);
		
        $submit = new Submit('submit');
        $submit->setValue($lang->text('tbird', 'save_btn_label'));
        $form->addElement($submit);

        if ( OW::getRequest()->isPost() && $form->isValid($_POST) )
        {
            $data = $form->getValues();
            if ( !empty($data['twitter_id']) && strlen(trim($data['twitter_id'])) > 0 )
            {
                $config->saveConfig('tbird', 'twitter_id', trim($data['twitter_id']));
				
                OW::getFeedback()->info($lang->text('tbird', 'admin_successfully_saved'));
            }
            else
            {
                OW::getFeedback()->error($lang->text('tbird', 'admin_save_failure'));
            }

            $this->redirect();
        }
		
		$fieldTwitterId->setValue($config->getValue('tbird', 'twitter_id'));
		
        $this->addForm($form);
    }
	
	public function freetips()
    {
		$config = OW::getConfig();
		$siteName = $config->getValue('base', 'site_name');
		$lang = OW::getLanguage();
		
		$this->setPageHeading(OW::getLanguage()->text('tbird', 'admin_freetips_heading', array('siteName' => $siteName)));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
		
		$cmp = "<script language='JavaScript' src='http://feed2js.org//feed2js.php?src=http%3A%2F%2Fwww.ewtnet.com%2Ffeeds%2Fposts%2Fdefault%2F-%2Foxwall&num=150&utf=y'  charset='UTF-8' type='text/javascript'>
		</script>";
		
		$this->assign('cmp', $cmp);
	}
	public function donate()
    {
		$config = OW::getConfig();
		$lang = OW::getLanguage();
		
		$this->setPageHeading(OW::getLanguage()->text('tbird', 'admin_donate_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
		
		$this->assign('donateInvitation', OW::getLanguage()->text('tbird', 'donate_invitation'));
		$cmp = '
			<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top">
				<input type="hidden" name="cmd" value="_s-xclick">
				<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----
				">
				<input type="image" src="https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">
				<img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">
			</form>
		';
		
		$this->assign('cmp', $cmp);
	}
}