<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is a proprietary licensed product. 
 * For more information see License.txt in the plugin folder.

 * ---
 * Copyright (c) 2015, Ebenezer Obasi
 * All rights reserved.
 * info@eobai.com.

 * Redistribution and use in source and binary forms, with or without modification, are not permitted provided.

 * This plugin should be bought from the developer. For details contact info@eobasi.com.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

$config = OW::getConfig();
$gr = OW::getRouter();
$twitterId = $config->getValue('tbird', 'twitter_id');

if ( !empty($twitterId) )
{

    function tbird_flying_bird()
    {
		$config = OW::getConfig();
		$gr = OW::getRouter();
		
		$twitterId = $config->getValue('tbird', 'twitter_id');
		
		$pageURL = 'http';
		if (@$_SERVER["HTTPS"] == "on") {
			$pageURL .= "s";
		}
		$pageURL .= "://";
		if ($_SERVER["SERVER_PORT"] != "80") {
			$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		} else {
			$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		
		$jsUrl = OW::getPluginManager()->getPlugin('tbird')->getStaticJsUrl() . 'twitter.js';
		$birdSprite = OW::getPluginManager()->getPlugin('tbird')->getStaticUrl() . 'img/tbird.png';
		
		$script = '
		<script type="text/javascript">
			var birdSprite = "' .$birdSprite. '";
		</script>
		<script src="'.$jsUrl.'" type="text/javascript">
		</script>
		<script type="text/javascript">
			var twitterAccount = "' .$twitterId. '";
			var tweetThisText = ": ' . $pageURL . '";
			tripleflapInit();
		</script>';
		
		OW::getDocument()->appendBody($script);
    }
    OW::getEventManager()->bind(OW_EventManager::ON_FINALIZE, 'tbird_flying_bird');
}
 function tbird_add_bird()
{
	$flyingBird = '<p style="font-weight:bold;text-align:center;color:#587a43;"><span style="color:#587a43">Fully customizable, responsive lading page (Facebook Clone) plugin now available for just </span><span style="color:red">$16</span> [<a href="http://www.oxwall.org/store/item/1027" target="_blank">Open in New Tab</a>].<br />For reliability and stability, use Bluehost for your Oxwall site hosting [<a href="http://hosting1.toxwall.com/" target="_blank">Open in New Tab</a>].</p>';

	$script = '<script type="text/javascript">';
	$script .= "$(document).ready( function(){
		   $('.ow_admin_area .ow_content').append( '" . $flyingBird . "' );
		});
	   </script>";

	OW::getDocument()->appendBody($script);
}
OW::getEventManager()->bind(OW_EventManager::ON_BEFORE_DOCUMENT_RENDER, 'tbird_add_bird');
$gr->addRoute(new OW_Route('tbird_admin_settings', 'admin/plugins/tbird/settings', 'TBIRD_CTRL_Admin', 'settings'));
$gr->addRoute(new OW_Route('tbird_admin_freetips', 'admin/plugins/tbird/settings/freetips', 'TBIRD_CTRL_Admin', 'freetips'));
$gr->addRoute(new OW_Route('tbird_admin_donate', 'admin/plugins/tbird/donate', 'TBIRD_CTRL_Admin', 'donate'));

function tbird_admin_notification( BASE_CLASS_EventCollector $event )
{
	$config = OW::getConfig();
	$twitterId = $config->getValue('tbird', 'twitter_id');
	$gr = OW::getRouter();

    if ( empty($twitterId) )
    {
        $event->add(OW::getLanguage()->text('tbird', 'admin_notification_text', array('link' => $gr->urlForRoute('tbird_admin_settings'))));
    }
}
OW::getEventManager()->bind('admin.add_admin_notification', 'tbird_admin_notification');

		