<?php

/**
 * This software is intended for use with Oxwall Free Community Software http://www.oxwall.org/ and is a proprietary licensed product. 
 * For more information see License.txt in the plugin folder.

 * ---
 * Copyright (c) 2015, Ebenezer Obasi
 * All rights reserved.
 * info@eobai.com.

 * Redistribution and use in source and binary forms, with or without modification, are not permitted provided.

 * This plugin should be bought from the developer. For details contact info@eobasi.com.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

$config = OW::getConfig();
$gr = OW::getRouter();
$yPosition = $config->getValue('fbslide', 'y_position');
$shareBoxPosition = $yPosition + 12;
function fbslide_slide_out()
{
	$config = OW::getConfig();
	$gr = OW::getRouter();
	$yPosition = $config->getValue('fbslide', 'y_position');
	$shareBoxPosition = $yPosition + 12;
	$pageURL = 'http';
	if (@$_SERVER["HTTPS"] == "on") {
		$pageURL .= "s";
	}
	$pageURL .= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
		$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	} else {
		$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	}
	OW::getDocument()->addStyleSheet(OW::getPluginManager()->getPlugin('fbslide')->getStaticCssUrl() . 'style.css');

	if (!empty($yPosition) ){
		OW::getDocument()->addCustomHeadInfo('
		<style>
			#fbslide_fixed_share{'.$yPosition.'px !important;}
			#fbslide_share_box{'.$shareBoxPosition.'px !important;}
		</style>
		');
	}
	
	$fbIcon = OW::getPluginManager()->getPlugin('fbslide')->getStaticUrl() . 'img/fb.png';	
	$fb = '"//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5"';
	$txt = OW::getLanguage()->text('fbslide', 'slide_out_txt');
	$script = "
		<script>(function(d, s, id) {
		var js, fjs = d.getElementsByTagName(s)[0];
		if (d.getElementById(id)) return;
		js = d.createElement(s); js.id = id;
		js.src = $fb;
		fjs.parentNode.insertBefore(js, fjs);
		}(document, 'script', 'facebook-jssdk'));</script> 
		<div id='fbslide_fixed_share'>
			<div id='fbslide_share_box'>
				<img src='$fbIcon' />
			</div>
			<span>
				$txt <br />
				<div class='fb-share-button' data-href='$pageURL' data-layout='button_count'></div>
			</span>
		</div>
	";
	OW::getDocument()->appendBody($script);
}
OW::getEventManager()->bind(OW_EventManager::ON_FINALIZE, 'fbslide_slide_out');

$gr->addRoute(new OW_Route('fbslide_admin_settings', 'admin/plugins/fbslide/settings', 'FBSLIDE_CTRL_Admin', 'settings'));
$gr->addRoute(new OW_Route('fbslide_admin_freetips', 'admin/plugins/fbslide/settings/freetips', 'FBSLIDE_CTRL_Admin', 'freetips'));
$gr->addRoute(new OW_Route('fbslide_admin_donate', 'admin/plugins/fbslide/donate', 'FBSLIDE_CTRL_Admin', 'donate'));

function fbslide_admin_notification( BASE_CLASS_EventCollector $event )
{
	$config = OW::getConfig();
	$yPosition = $config->getValue('fbslide', 'y_position');
	$gr = OW::getRouter();

    if ( empty($yPosition) )
    {
        $event->add(OW::getLanguage()->text('fbslide', 'admin_notification_text', array('link' => $gr->urlForRoute('fbslide_admin_settings'))));
    }
}
OW::getEventManager()->bind('admin.add_admin_notification', 'fbslide_admin_notification');

		