<?php
/**
 * @package   iFlyChat
 * @version   1.0.0
 * @copyright Copyright (C) 2014 iFlyChat. All rights reserved.
 * @license   GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @author    iFlyChat Team
 * @link      https://iflychat.com
 */


require_once(OW_DIR_PLUGIN . 'iflychat' . DS . 'helper.php');
//define('IFLYCHAT_EXTERNAL_A_HOST', 'https://api.iflychat.com');
//define('IFLYCHAT_EXTERNAL_A_PORT', '443');
class IFLYCHAT_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function __construct()
    {
        parent::__construct();
        $language = OW::getLanguage();
        $this->setPageHeading($language->text("iflychat", "iflychat_setting_page"));

        $general = new BASE_MenuItem();
        $general->setLabel('Plugin setting');
        $general->setUrl(OW::getRouter()->urlForRoute('iflychat_admin'));
        $general->setKey('iflychat_settings');
        $general->setIconClass('ow_ic_gear_wheel');
        $general->setOrder(0);

        $view = new BASE_MenuItem();
        $view->setLabel('App setting');
        $view->setUrl(OW::getRouter()->urlForRoute('iflychat_admin_customization'));
        $view->setKey('iflychat_customization');
        $view->setIconClass('ow_ic_files');
        $view->setOrder(1);

        $menu = new BASE_CMP_ContentMenu(array($general, $view));
        $this->addComponent('menu', $menu);
    }

    public function index()
    {

        $obj = new iflychatHelper;
        $language = OW::getLanguage();
        OW::getDocument()->addScript(OW::getPluginManager()->getPlugin('iflychat')->getStaticJsUrl() . 'iflychat-admin.js');
        $config = OW::getConfig();
        $configs = $config->getValues('iflychat');
        $this->assign('configs', $configs);
        $form = new IFLYCHAT_ConfigSaveForm($configs);
        $embedChatDescription = $language->text('iflychat', 'Embed_chat_Description');
//        $embedChatButtonDescription = $language->text('iflychat', 'Embed_chat_button_Description');
        $this->assign('embedChatDescription', $embedChatDescription);
//        $this->assign('embedChatButtonDescription', $embedChatButtonDescription);
        $this->addForm($form);

        if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
            if ($form->process($_POST)) {
                $data = $form->getValues();
                //generate request on save button
                $response = $obj->generateToken($data['iflychat_external_api_key']);
                $response = json_decode($response);
                if (isset($response->code) && $response->code === 200) {
                    if (isset($response->app_id)) {
                        $data2 = array(
                            'iflychat_app_id' => $response->app_id
                        );
                        $data = array_merge($data, $data2);
                        $config->saveConfig('iflychat', 'setting_vars', json_encode(array_merge($data, $data2)));
                    }

                    $form->process(json_encode($data));
                    OW::getFeedback()->info($language->text('iflychat', 'settings_updated'));
                    $this->redirect();
                } else {
                    OW::getFeedback()->error('Invalid Api key');
                }
            } else {
                OW::getFeedback()->error(OW::getLanguage()->text('iflychat', 'admin_index_form_save_error_message'));
                $this->redirect();
            }

        }

        $default = array(
            'iflychat_external_api_key' => '',
            'iflychat_app_id' => '',
            'iflychat_show_popup_chat' => '1',
            'iflychat_enable_friends' => '1',
            'iflychat_path_pages' => '',
            'iflychat_moderators' => '',
            'iflychat_administers' => ''
        );

        $settingsJson = OW::getConfig()->getValue('iflychat', 'setting_vars');
        $settingsArray = (array)json_decode($settingsJson);
        foreach ($settingsArray as $key => $value) {
            if (empty($value)) {
                $settingsArray[$key] = $default[$key];
                $form->setValues($settingsArray);
                $this->addForm($form);
            }
        }
    }

    public function customization()
    {
        $obj = new iflychatHelper;
        $iflychat_host = IFLYCHAT_EXTERNAL_A_HOST;
        $host = explode("/", $iflychat_host);
        $host_name = $host[2];
        $token = '';
            $response = $obj->generateToken($obj->params('iflychat_external_api_key'));
            $response = json_decode($response);
            if ($response->code === 200) {
//                $_SESSION['token'] = $response->key;
                $token = $response->key;
            }
        $dashboardUrl = "//".IFLYCHAT_EXTERNAL_CDN_HOST."/apps/dashboard/#/app-settings?sessid=" . $token . "&hostName=" . $host_name . "&hostPort=" . IFLYCHAT_EXTERNAL_A_PORT;
//        $buttonDescription = $language->text("iflychat", "MOD_IFLYCHAT_BUTTON_DESCRIPTION");
        $form = new IFLYCHAT_CustomizationForm();
        $this->assign('dashboardUrl', $dashboardUrl);
//        $this->assign('buttonDescription', $buttonDescription);
        $this->addForm($form);
    }
}

class IFLYCHAT_ConfigSaveForm extends Form
{

    public function __construct($configs)
    {

        parent::__construct('IFLYCHAT_ConfigSaveForm');
        $language = OW::getLanguage();


//General settings
        $textField = new TextField("iflychat_app_id");
        $textField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_APP_ID"));
        $textField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_APP_ID_DESC"));
        $this->addElement($textField);

        $textField = new TextField("iflychat_external_api_key");
        $textField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_API_KEY"));
        $textField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_API_KEY_DESC"));
        $textField->setRequired();
        $this->addElement($textField);

        $selectField = new Selectbox("iflychat_show_popup_chat");
        $selectField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_SHOW_POPUP_CHAT"));
        $selectField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_SHOW_POPUP_CHAT_DESC"));
        $selectField->setValue('1');
        $selectField->setOptions(array(
            "1" => "Everywhere",
            "2" => "Frontend Only",
            "3" => "Everywhere except those listed page",
            "4" => "Only the list page",
            "5" => "Disable"
        ));
        $this->addElement($selectField);

        $textareaField = new Textarea("iflychat_path_pages");
        $textareaField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_PATH_PAGES"));
        $textareaField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_PATH_PAGES_DESC"));
        $this->addElement($textareaField);


        $textareaField = new Textarea("iflychat_moderators");
        $textareaField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_MODERATORS"));
        $textareaField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_MODERATORS_DESC"));
        $this->addElement($textareaField);

        $textareaField = new Textarea("iflychat_administers");
        $textareaField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_ADMINISTERS"));
        $textareaField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_ADMINISTERS_DESC"));
        $this->addElement($textareaField);

        $selectField = new Selectbox("iflychat_enable_friends");
        $selectField->setLabel($language->text("iflychat", "MOD_IFLYCHAT_ENABLE_FRIENDS"));
        $selectField->setDescription($language->text("iflychat", "MOD_IFLYCHAT_ENABLE_FRIENDS_DESC"));
        $selectField->setValue('1');
        $selectField->setOptions(array(
            "1" => "No",
            "2" => "Yes"
        ));
        $this->addElement($selectField);

        $submit = new Submit('submit');
        $submit->setValue('Save');
        $this->addElement($submit);

    }

    public function process($data)
    {
        $config = OW::getConfig();
        $config->saveConfig('iflychat', 'setting_vars', $data);
        return true;
    }
}

class IFLYCHAT_CustomizationForm extends Form
{

    public function __construct()
    {
        parent::__construct('IFLYCHAT_CustomizationForm');
    }

    public function process($data)
    {
        return true;
    }
}